/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.component;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.CommonTickingComponent;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ModifyPlayerSpawnPower;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.power.OriginsCallbackPower;
import io.github.apace100.origins.registry.ModComponents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2960;

public interface OriginComponent
extends AutoSyncedComponent,
CommonTickingComponent {
    public HashMap<OriginLayer, Origin> getOrigins();

    public Origin getOrigin(OriginLayer var1);

    public boolean hasSelectionInvulnerability();

    public boolean isSelectingOrigin();

    public boolean hasOrigin(OriginLayer var1);

    public boolean hasAllOrigins();

    public boolean hadOriginBefore();

    public void selectingOrigin(boolean var1);

    public void setOrigin(OriginLayer var1, Origin var2);

    public void sync();

    public static void sync(class_1657 player) {
        ModComponents.ORIGIN.sync((Object)player);
        PowerHolderComponent.KEY.sync((Object)player);
    }

    public static void onChosen(class_1657 player, boolean hadOriginBefore) {
        if (!hadOriginBefore) {
            PowerHolderComponent.getPowers((class_1297)player, ModifyPlayerSpawnPower.class).forEach(ModifyPlayerSpawnPower::teleportToModifiedSpawn);
        }
        PowerHolderComponent.getPowers((class_1297)player, OriginsCallbackPower.class).forEach(p -> p.onChosen(hadOriginBefore));
    }

    public static void partialOnChosen(class_1657 player, boolean hadOriginBefore, Origin origin) {
        PowerHolderComponent powerHolder = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)player);
        for (PowerType powerType : powerHolder.getPowersFromSource(origin.getIdentifier())) {
            Power p = powerHolder.getPower(powerType);
            if (p instanceof ModifyPlayerSpawnPower && !hadOriginBefore) {
                ((ModifyPlayerSpawnPower)p).teleportToModifiedSpawn();
                continue;
            }
            if (!(p instanceof OriginsCallbackPower)) continue;
            ((OriginsCallbackPower)p).onChosen(hadOriginBefore);
        }
    }

    default public boolean checkAutoChoosingLayers(class_1657 player, boolean includeDefaults) {
        ArrayList layers = new ArrayList();
        boolean choseOneAutomatically = false;
        OriginLayers.getLayers().stream().filter(OriginLayer::isEnabled).forEach(layers::add);
        Collections.sort(layers);
        for (OriginLayer layer : layers) {
            if (!layer.isEnabled() || this.hasOrigin(layer)) continue;
            if (includeDefaults && layer.hasDefaultOrigin()) {
                this.setOrigin(layer, OriginRegistry.get(layer.getDefaultOrigin()));
                choseOneAutomatically = true;
                continue;
            }
            if (layer.getOriginOptionCount(player) != 1 || !layer.shouldAutoChoose()) continue;
            List<Origin> origins = layer.getOrigins(player).stream().map(OriginRegistry::get).filter(Origin::isChoosable).toList();
            if (!origins.isEmpty()) {
                this.setOrigin(layer, origins.get(0));
            } else {
                List<class_2960> randomOriginIds = layer.getRandomOrigins(player);
                int randomOriginIndex = player.method_6051().method_43048(randomOriginIds.size());
                this.setOrigin(layer, OriginRegistry.get(randomOriginIds.get(randomOriginIndex)));
            }
            choseOneAutomatically = true;
        }
        if (choseOneAutomatically) {
            this.selectingOrigin(false);
        }
        return choseOneAutomatically;
    }
}

