/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.ConfigValue;
import net.mehvahdjukaar.moonlight.core.Moonlight;

public class JsonConfigValue
extends ConfigValue<JsonElement> {
    private final Supplier<JsonElement> defValue = Suppliers.memoize(defaultSupplier::get);

    public JsonConfigValue(String name, java.util.function.Supplier<JsonElement> defaultSupplier) {
        super(name, null);
    }

    @Override
    public boolean isValid(JsonElement value) {
        return value.isJsonObject();
    }

    @Override
    public void loadFromJson(JsonObject element) {
        if (element.has(this.name)) {
            try {
                this.value = element.get(this.name);
                if (this.isValid((JsonElement)this.value)) {
                    return;
                }
                this.value = this.getDefaultValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Moonlight.LOGGER.warn("Config file had incorrect entry {}, correcting", (Object)this.name);
        } else {
            Moonlight.LOGGER.warn("Config file had missing entry {}", (Object)this.name);
        }
    }

    @Override
    public JsonElement getDefaultValue() {
        return (JsonElement)this.defValue.get();
    }

    @Override
    public void saveToJson(JsonObject object) {
        if (this.value == null) {
            this.value = this.getDefaultValue();
        }
        object.add(this.name, (JsonElement)this.value);
    }
}

