/*
 * Decompiled with CFR 0.152.
 */
package github.kituin.chatimage.network;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import github.kituin.chatimage.ChatImage;
import io.github.kituin.ChatImageCode.ChatImageFrame;
import io.github.kituin.ChatImageCode.ChatImageIndex;
import io.github.kituin.ChatImageCode.ClientStorage;
import io.github.kituin.ChatImageCode.NetworkHelper;
import io.github.kituin.ChatImageCode.ServerStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ChatImagePacket {
    public static class_2960 FILE_CHANNEL = new class_2960("chatimage", "file_channel");
    public static class_2960 GET_FILE_CHANNEL = new class_2960("chatimage", "get_file_channel");
    public static class_2960 DOWNLOAD_FILE_CHANNEL = new class_2960("chatimage", "download_file_channel");
    public static Gson gson = new Gson();

    public static class_2540 createStringPacket(String str) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(str);
        return buf;
    }

    public static void sendPacketAsync(class_3222 player, class_2960 channel, class_2540 buf) {
        CompletableFuture.supplyAsync(() -> {
            ServerPlayNetworking.send((class_3222)player, (class_2960)channel, (class_2540)buf);
            return null;
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendPacketAsync(class_2960 channel, class_2540 buf) {
        CompletableFuture.supplyAsync(() -> {
            ClientPlayNetworking.send((class_2960)channel, (class_2540)buf);
            return null;
        });
    }

    public static void sendPacketAsync(class_2960 channel, List<String> bufs) {
        for (String buf : bufs) {
            ChatImagePacket.sendPacketAsync(channel, ChatImagePacket.createStringPacket(buf));
        }
    }

    public static void loadFromServer(String url) {
        if (class_310.method_1551().field_1724 != null) {
            ChatImagePacket.sendPacketAsync(GET_FILE_CHANNEL, ChatImagePacket.createStringPacket(url));
            ChatImage.LOGGER.info("[GetFileChannel-Try]" + url);
        } else {
            ClientStorage.AddImageError((String)url, (ChatImageFrame.FrameError)ChatImageFrame.FrameError.FILE_NOT_FOUND);
        }
    }

    public static void serverFileChannelReceived(MinecraftServer server, class_2540 buf) {
        String res = buf.method_19772();
        ChatImageIndex title = (ChatImageIndex)gson.fromJson(res, ChatImageIndex.class);
        HashMap blocks = ServerStorage.SERVER_BLOCK_CACHE.containsKey(title.url) ? (HashMap)ServerStorage.SERVER_BLOCK_CACHE.get(title.url) : new HashMap();
        blocks.put(title.index, res);
        ServerStorage.SERVER_BLOCK_CACHE.put(title.url, blocks);
        ServerStorage.FILE_COUNT_MAP.put(title.url, title.total);
        ChatImage.LOGGER.info("[FileChannel->Server:" + title.index + "/" + title.total + "]" + title.url);
        if (title.total == blocks.size()) {
            if (ServerStorage.USER_CACHE_MAP.containsKey(title.url)) {
                List names = (List)ServerStorage.USER_CACHE_MAP.get(title.url);
                for (String uuid : names) {
                    class_3222 serverPlayer = server.method_3760().method_14602(UUID.fromString(uuid));
                    ChatImagePacket.sendPacketAsync(serverPlayer, GET_FILE_CHANNEL, ChatImagePacket.createStringPacket("true->" + title.url));
                    ChatImage.LOGGER.info("[FileChannel->Client(" + uuid + ")]" + title.url);
                }
                ServerStorage.USER_CACHE_MAP.put(title.url, Lists.newArrayList());
            }
            ChatImage.LOGGER.info("[FileChannel->Server]" + title.url);
        }
    }

    public static void serverGetFileChannelReceived(class_3222 player, class_2540 buf) {
        String url = buf.method_19772();
        if (ServerStorage.SERVER_BLOCK_CACHE.containsKey(url) && ServerStorage.FILE_COUNT_MAP.containsKey(url)) {
            HashMap list = (HashMap)ServerStorage.SERVER_BLOCK_CACHE.get(url);
            Integer total = (Integer)ServerStorage.FILE_COUNT_MAP.get(url);
            if (total.intValue() == list.size()) {
                for (Map.Entry entry : list.entrySet()) {
                    ChatImagePacket.sendPacketAsync(player, DOWNLOAD_FILE_CHANNEL, ChatImagePacket.createStringPacket((String)entry.getValue()));
                    ChatImage.LOGGER.debug("[GetFileChannel->Client:" + entry.getKey() + "/" + (list.size() - 1) + "]" + url);
                }
                ChatImage.LOGGER.info("[GetFileChannel->Client]" + url);
                return;
            }
        }
        ChatImagePacket.sendPacketAsync(player, GET_FILE_CHANNEL, ChatImagePacket.createStringPacket("null->" + url));
        ChatImage.LOGGER.error("[GetFileChannel]not found in server:" + url);
        ArrayList names = ServerStorage.USER_CACHE_MAP.containsKey(url) ? (List)ServerStorage.USER_CACHE_MAP.get(url) : Lists.newArrayList();
        names.add(player.method_5845());
        ServerStorage.USER_CACHE_MAP.put(url, names);
        ChatImage.LOGGER.info("[GetFileChannel]\u8bb0\u5f55uuid:" + player.method_5845());
    }

    public static void clientGetFileChannelReceived(class_2540 buf) {
        String data = buf.method_19772();
        String url = data.substring(6);
        ChatImage.LOGGER.info(url);
        if (data.startsWith("null")) {
            ChatImage.LOGGER.info("[GetFileChannel-NULL]" + url);
            ClientStorage.AddImageError((String)url, (ChatImageFrame.FrameError)ChatImageFrame.FrameError.FILE_NOT_FOUND);
        } else if (data.startsWith("true")) {
            ChatImagePacket.loadFromServer(url);
        }
    }

    public static void clientDownloadFileChannelReceived(class_2540 buf) {
        String res = buf.method_19772();
        ChatImageIndex title = (ChatImageIndex)gson.fromJson(res, ChatImageIndex.class);
        HashMap blocks = ClientStorage.CLIENT_CACHE_MAP.containsKey(title.url) ? (HashMap)ClientStorage.CLIENT_CACHE_MAP.get(title.url) : new HashMap();
        blocks.put(title.index, title);
        ClientStorage.CLIENT_CACHE_MAP.put(title.url, blocks);
        ChatImage.LOGGER.info("[DownloadFile(" + title.index + "/" + title.total + ")]" + title.url);
        if (blocks.size() == title.total) {
            ChatImage.LOGGER.info(String.valueOf(blocks));
            NetworkHelper.mergeFileBlocks((String)title.url, (Map)blocks);
            ChatImage.LOGGER.info("[DownloadFileChannel-Merge]" + title.url);
        }
    }
}

