/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.diodes;

import com.simibubi.create.content.redstone.diodes.BrassDiodeBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_5250;

public class BrassDiodeScrollValueBehaviour
extends ScrollValueBehaviour {
    public BrassDiodeScrollValueBehaviour(class_2561 label, SmartBlockEntity be, ValueBoxTransform slot) {
        super(label, be, slot);
    }

    @Override
    public ValueSettingsBoard createBoard(class_1657 player, class_3965 hitResult) {
        return new ValueSettingsBoard(this.label, 60, 10, Lang.translatedOptions("generic.unit", "ticks", "seconds", "minutes"), new ValueSettingsFormatter(this::formatSettings));
    }

    @Override
    public void onShortInteract(class_1657 player, class_1268 hand, class_2350 side) {
        class_2680 blockState = this.blockEntity.method_11010();
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof BrassDiodeBlock) {
            BrassDiodeBlock bdb = (BrassDiodeBlock)class_22482;
            bdb.toggle(this.getWorld(), this.getPos(), blockState, player, hand);
        }
    }

    @Override
    public void setValueSettings(class_1657 player, ValueSettingsBehaviour.ValueSettings valueSetting, boolean ctrlHeld) {
        int multiplier;
        int value = valueSetting.value();
        switch (valueSetting.row()) {
            case 0: {
                int n = 1;
                break;
            }
            case 1: {
                int n = 20;
                break;
            }
            default: {
                int n = multiplier = 1200;
            }
        }
        if (!valueSetting.equals(this.getValueSettings())) {
            this.playFeedbackSound(this);
        }
        this.setValue(Math.max(2, Math.max(1, value) * multiplier));
    }

    @Override
    public ValueSettingsBehaviour.ValueSettings getValueSettings() {
        int row = 0;
        int value = this.value;
        if (value > 1200) {
            value /= 1200;
            row = 2;
        } else if (value > 60) {
            value /= 20;
            row = 1;
        }
        return new ValueSettingsBehaviour.ValueSettings(row, value);
    }

    public class_5250 formatSettings(ValueSettingsBehaviour.ValueSettings settings) {
        int value = Math.max(1, settings.value());
        return Components.literal(switch (settings.row()) {
            case 0 -> Math.max(2, value) + "t";
            case 1 -> "0:" + (value < 10 ? "0" : "") + value;
            default -> value + ":00";
        });
    }

    @Override
    public String getClipboardKey() {
        return "Timings";
    }
}

