/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.element.BoxElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widget.BoxWidget;
import com.simibubi.create.foundation.ponder.PonderChapter;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderTag;
import com.simibubi.create.foundation.ponder.ui.ChapterLabel;
import com.simibubi.create.foundation.ponder.ui.LayoutHelper;
import com.simibubi.create.foundation.ponder.ui.NavigatableSimiScreen;
import com.simibubi.create.foundation.ponder.ui.PonderButton;
import com.simibubi.create.foundation.ponder.ui.PonderUI;
import com.simibubi.create.foundation.utility.FontHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_768;
import net.minecraft.class_7923;

public class PonderTagScreen
extends NavigatableSimiScreen {
    public static final String ASSOCIATED = "ponder.associated";
    private final PonderTag tag;
    protected final List<class_1792> items;
    private final double itemXmult = 0.5;
    protected class_768 itemArea;
    protected final List<PonderChapter> chapters;
    private final double chapterXmult = 0.5;
    private final double chapterYmult = 0.75;
    protected class_768 chapterArea;
    private final double mainYmult = 0.15;
    private class_1799 hoveredItem = class_1799.field_8037;

    public PonderTagScreen(PonderTag tag) {
        this.tag = tag;
        this.items = new ArrayList<class_1792>();
        this.chapters = new ArrayList<PonderChapter>();
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.items.clear();
        PonderRegistry.TAGS.getItems(this.tag).stream().map(key -> class_7923.field_41178.method_17966(key).or(() -> class_7923.field_41175.method_17966(key).map(class_2248::method_8389)).orElse(null)).filter(Objects::nonNull).forEach(this.items::add);
        if (!this.tag.getMainItem().method_7960()) {
            this.items.remove(this.tag.getMainItem().method_7909());
        }
        int rowCount = class_3532.method_15340((int)((int)Math.ceil((double)this.items.size() / 11.0)), (int)1, (int)3);
        LayoutHelper layout = LayoutHelper.centeredHorizontal(this.items.size(), rowCount, 28, 28, 8);
        this.itemArea = layout.getArea();
        int itemCenterX = (int)((double)this.field_22789 * 0.5);
        int itemCenterY = this.getItemsY();
        for (class_1792 i : this.items) {
            Object b = new PonderButton(itemCenterX + layout.getX() + 4, itemCenterY + layout.getY() + 4).showing(new class_1799((class_1935)i));
            if (PonderRegistry.ALL.containsKey(RegisteredObjects.getKeyOrThrow(i))) {
                ((AbstractSimiWidget)b).withCallback((mouseX, mouseY) -> {
                    this.centerScalingOn((int)mouseX, (int)mouseY);
                    ScreenOpener.transitionTo(PonderUI.of(new class_1799((class_1935)i), this.tag));
                });
            } else if (RegisteredObjects.getKeyOrThrow(i).method_12836().equals("create")) {
                ((BoxWidget)((BoxWidget)b).withBorderColors(Theme.p(Theme.Key.PONDER_MISSING_CREATE))).animateColors(false);
            } else {
                ((BoxWidget)((BoxWidget)b).withBorderColors(Theme.p(Theme.Key.PONDER_MISSING_VANILLA))).animateColors(false);
            }
            this.method_37063((class_364)b);
            layout.next();
        }
        if (!this.tag.getMainItem().method_7960()) {
            class_2960 registryName = RegisteredObjects.getKeyOrThrow(this.tag.getMainItem().method_7909());
            Object b = new PonderButton(itemCenterX - layout.getTotalWidth() / 2 - 48, itemCenterY - 10).showing(this.tag.getMainItem());
            ((BoxWidget)b).withCustomBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_IMPORTANT));
            if (PonderRegistry.ALL.containsKey(registryName)) {
                ((AbstractSimiWidget)b).withCallback((mouseX, mouseY) -> {
                    this.centerScalingOn((int)mouseX, (int)mouseY);
                    ScreenOpener.transitionTo(PonderUI.of(this.tag.getMainItem(), this.tag));
                });
            } else if (registryName.method_12836().equals("create")) {
                ((BoxWidget)((BoxWidget)b).withBorderColors(Theme.p(Theme.Key.PONDER_MISSING_CREATE))).animateColors(false);
            } else {
                ((BoxWidget)((BoxWidget)b).withBorderColors(Theme.p(Theme.Key.PONDER_MISSING_VANILLA))).animateColors(false);
            }
            this.method_37063((class_364)b);
        }
        this.chapters.clear();
        this.chapters.addAll(PonderRegistry.TAGS.getChapters(this.tag));
        rowCount = class_3532.method_15340((int)((int)Math.ceil((float)this.chapters.size() / 3.0f)), (int)1, (int)3);
        layout = LayoutHelper.centeredHorizontal(this.chapters.size(), rowCount, 200, 38, 16);
        this.chapterArea = layout.getArea();
        int chapterCenterX = (int)((double)this.field_22789 * 0.5);
        int chapterCenterY = (int)((double)this.field_22790 * 0.75);
        for (PonderChapter chapter : this.chapters) {
            ChapterLabel label = new ChapterLabel(chapter, chapterCenterX + layout.getX(), chapterCenterY + layout.getY(), (mouseX, mouseY) -> {
                this.centerScalingOn((int)mouseX, (int)mouseY);
                ScreenOpener.transitionTo(PonderUI.of(chapter));
            });
            this.method_37063(label);
            layout.next();
        }
    }

    @Override
    protected void initBackTrackIcon(PonderButton backTrack) {
        backTrack.showing(this.tag);
    }

    @Override
    public void method_25393() {
        super.method_25393();
        ++PonderUI.ponderTicks;
        this.hoveredItem = class_1799.field_8037;
        class_1041 w = this.field_22787.method_22683();
        double mouseX = this.field_22787.field_1729.method_1603() * (double)w.method_4486() / (double)w.method_4480();
        double mouseY = this.field_22787.field_1729.method_1604() * (double)w.method_4502() / (double)w.method_4507();
        for (class_364 child : this.method_25396()) {
            PonderButton button;
            if (child == this.backTrack || !(child instanceof PonderButton) || !(button = (PonderButton)child).method_25405(mouseX, mouseY)) continue;
            this.hoveredItem = button.getItem();
        }
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderItems(graphics, mouseX, mouseY, partialTicks);
        this.renderChapters(graphics, mouseX, mouseY, partialTicks);
        class_4587 ms = graphics.method_51448();
        ms.method_22903();
        ms.method_22904((double)(this.field_22789 / 2 - 120), (double)this.field_22790 * 0.15 - 40.0, 0.0);
        ms.method_22903();
        int x = 59;
        int y = 31;
        String title = this.tag.getTitle();
        int streakHeight = 35;
        UIRenderHelper.streak(graphics, 0.0f, x - 4, y - 12 + streakHeight / 2, streakHeight, 240);
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.PONDER_IDLE))).at(21.0f, 21.0f, 100.0f)).withBounds(30, 30)).render(graphics);
        graphics.method_51439(this.field_22793, (class_2561)Lang.translateDirect("ponder.pondering", new Object[0]), x, y - 6, Theme.i(Theme.Key.TEXT_DARKER), false);
        ms.method_46416((float)(x += 0), (float)(y += 8), 0.0f);
        ms.method_46416(0.0f, 0.0f, 5.0f);
        graphics.method_51433(this.field_22793, title, 0, 0, Theme.i(Theme.Key.TEXT), false);
        ms.method_22909();
        ms.method_22903();
        ms.method_46416(23.0f, 23.0f, 10.0f);
        ms.method_22905(1.66f, 1.66f, 1.66f);
        this.tag.render(graphics, 0, 0);
        ms.method_22909();
        ms.method_22909();
        ms.method_22903();
        int w = (int)((double)this.field_22789 * 0.45);
        x = (this.field_22789 - w) / 2;
        y = this.getItemsY() - 10 + Math.max(this.itemArea.method_3320(), 48);
        String desc = this.tag.getDescription();
        int h = this.field_22793.method_1713(desc, w);
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.PONDER_IDLE))).at(x - 3, y - 3, 90.0f)).withBounds(w + 6, h + 6)).render(graphics);
        ms.method_46416(0.0f, 0.0f, 100.0f);
        FontHelper.drawSplitString(ms, this.field_22793, desc, x, y, w, Theme.i(Theme.Key.TEXT));
        ms.method_22909();
    }

    protected void renderItems(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.items.isEmpty()) {
            return;
        }
        int x = (int)((double)this.field_22789 * 0.5);
        int y = this.getItemsY();
        String relatedTitle = Lang.translateDirect(ASSOCIATED, new Object[0]).getString();
        int stringWidth = this.field_22793.method_1727(relatedTitle);
        class_4587 ms = graphics.method_51448();
        ms.method_22903();
        ms.method_46416((float)x, (float)y, 0.0f);
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.PONDER_IDLE))).at((float)(this.windowWidth - stringWidth) / 2.0f - 5.0f, this.itemArea.method_3322() - 21, 100.0f)).withBounds(stringWidth + 10, 10)).render(graphics);
        ms.method_46416(0.0f, 0.0f, 200.0f);
        graphics.method_25300(this.field_22793, relatedTitle, this.windowWidth / 2, this.itemArea.method_3322() - 20, Theme.i(Theme.Key.TEXT));
        ms.method_46416(0.0f, 0.0f, -200.0f);
        UIRenderHelper.streak(graphics, 0.0f, 0, 0, this.itemArea.method_3320() + 10, this.itemArea.method_3319() / 2 + 75);
        UIRenderHelper.streak(graphics, 180.0f, 0, 0, this.itemArea.method_3320() + 10, this.itemArea.method_3319() / 2 + 75);
        ms.method_22909();
    }

    public int getItemsY() {
        return (int)(0.15 * (double)this.field_22790 + 85.0);
    }

    protected void renderChapters(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.chapters.isEmpty()) {
            return;
        }
        int chapterX = (int)((double)this.field_22789 * 0.5);
        int chapterY = (int)((double)this.field_22790 * 0.75);
        class_4587 ms = graphics.method_51448();
        ms.method_22903();
        ms.method_46416((float)chapterX, (float)chapterY, 0.0f);
        UIRenderHelper.streak(graphics, 0.0f, this.chapterArea.method_3321() - 10, this.chapterArea.method_3322() - 20, 20, 220);
        graphics.method_51433(this.field_22793, "More Topics to Ponder about", this.chapterArea.method_3321() - 5, this.chapterArea.method_3322() - 25, Theme.i(Theme.Key.TEXT_ACCENT_SLIGHT), false);
        ms.method_22909();
    }

    @Override
    protected void renderWindowForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.disableDepthTest();
        class_4587 ms = graphics.method_51448();
        ms.method_22903();
        ms.method_46416(0.0f, 0.0f, 200.0f);
        if (!this.hoveredItem.method_7960()) {
            graphics.method_51446(this.field_22793, this.hoveredItem, mouseX, mouseY);
        }
        ms.method_22909();
        RenderSystem.enableDepthTest();
    }

    @Override
    protected String getBreadcrumbTitle() {
        return this.tag.getTitle();
    }

    public class_1799 getHoveredTooltipItem() {
        return this.hoveredItem;
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        if (other instanceof PonderTagScreen) {
            return this.tag == ((PonderTagScreen)other).tag;
        }
        return super.isEquivalentTo(other);
    }

    @Override
    public boolean method_25421() {
        return true;
    }

    public PonderTag getTag() {
        return this.tag;
    }

    public void method_25432() {
        super.method_25432();
        this.hoveredItem = class_1799.field_8037;
    }
}

