/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.event.common;

import cn.sh1rocu.tacz.api.LogicalSide;
import cn.sh1rocu.tacz.api.event.BaseEvent;
import cn.sh1rocu.tacz.api.event.ICancellableEvent;
import com.tacz.guns.api.event.common.GunDamageSourcePart;
import com.tacz.guns.api.event.common.KubeJSGunEventPoster;
import java.util.Optional;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

public class EntityHurtByGunEvent
extends BaseEvent
implements KubeJSGunEventPoster<EntityHurtByGunEvent> {
    protected final class_1297 bullet;
    @Nullable
    protected class_1297 hurtEntity;
    @Nullable
    protected class_1309 attacker;
    protected class_2960 gunId;
    protected class_2960 gunDisplayId;
    protected float baseAmount;
    protected class_1282 nonApPartDamageSource;
    protected class_1282 apPartDamageSource;
    protected boolean isHeadShot;
    protected float headshotMultiplier;
    protected final LogicalSide logicalSide;
    public static final Event<PreCallBack> PRE = EventFactory.createArrayBacked(PreCallBack.class, callbacks -> event -> {
        for (PreCallBack callback : callbacks) {
            callback.post(event);
        }
    });
    public static final Event<PostCallBack> POST = EventFactory.createArrayBacked(PostCallBack.class, callbacks -> event -> {
        for (PostCallBack callback : callbacks) {
            callback.post(event);
        }
    });

    @ApiStatus.Internal
    protected EntityHurtByGunEvent(class_1297 bullet, @Nullable class_1297 hurtEntity, @Nullable class_1309 attacker, class_2960 gunId, class_2960 gunDisplayId, float baseAmount, @Nullable Pair<class_1282, class_1282> sources, boolean isHeadShot, float headshotMultiplier, LogicalSide logicalSide) {
        this.bullet = bullet;
        this.hurtEntity = hurtEntity;
        this.attacker = attacker;
        this.gunId = gunId;
        this.baseAmount = baseAmount;
        this.nonApPartDamageSource = Optional.ofNullable(sources).map(Pair::getLeft).orElse(null);
        this.apPartDamageSource = Optional.ofNullable(sources).map(Pair::getRight).orElse(null);
        this.isHeadShot = isHeadShot;
        this.headshotMultiplier = headshotMultiplier;
        this.logicalSide = logicalSide;
    }

    public class_1297 getBullet() {
        return this.bullet;
    }

    @Nullable
    public class_1297 getHurtEntity() {
        return this.hurtEntity;
    }

    @Nullable
    public class_1309 getAttacker() {
        return this.attacker;
    }

    public class_2960 getGunId() {
        return this.gunId;
    }

    public class_2960 getGunDisplayId() {
        return this.gunDisplayId;
    }

    @ApiStatus.Obsolete
    public float getAmount() {
        return this.baseAmount * this.headshotMultiplier;
    }

    public float getBaseAmount() {
        return this.baseAmount;
    }

    public class_1282 getDamageSource(GunDamageSourcePart part) {
        if (this.logicalSide.isClient()) {
            throw new UnsupportedOperationException("DamageSource about gun hit is not available on client side!");
        }
        return part == GunDamageSourcePart.ARMOR_PIERCING ? this.apPartDamageSource : this.nonApPartDamageSource;
    }

    public float getHeadshotMultiplier() {
        return this.headshotMultiplier;
    }

    public boolean isHeadShot() {
        return this.isHeadShot;
    }

    public LogicalSide getLogicalSide() {
        return this.logicalSide;
    }

    public static interface PostCallBack {
        public void post(Post var1);
    }

    public static class Post
    extends EntityHurtByGunEvent {
        @ApiStatus.Internal
        public Post(class_1297 bullet, @Nullable class_1297 hurtEntity, @Nullable class_1309 attacker, class_2960 gunId, class_2960 gunDisplayId, float amount, @Nullable Pair<class_1282, class_1282> sources, boolean isHeadShot, float headshotMultiplier, LogicalSide logicalSide) {
            super(bullet, hurtEntity, attacker, gunId, gunDisplayId, amount, sources, isHeadShot, headshotMultiplier, logicalSide);
            this.postEventToKubeJS(this);
        }
    }

    public static interface PreCallBack {
        public void post(Pre var1);
    }

    public static class Pre
    extends EntityHurtByGunEvent
    implements ICancellableEvent {
        @ApiStatus.Internal
        public Pre(class_1297 bullet, @Nullable class_1297 hurtEntity, @Nullable class_1309 attacker, class_2960 gunId, class_2960 gunDisplayId, float amount, @Nullable Pair<class_1282, class_1282> sources, boolean isHeadShot, float headshotMultiplier, LogicalSide logicalSide) {
            super(bullet, hurtEntity, attacker, gunId, gunDisplayId, amount, sources, isHeadShot, headshotMultiplier, logicalSide);
            this.headshotMultiplier = headshotMultiplier;
            this.postEventToKubeJS(this);
        }

        public final void setHurtEntity(@Nullable class_1297 hurtEntity) {
            this.hurtEntity = hurtEntity;
        }

        public final void setAttacker(@Nullable class_1309 attacker) {
            this.attacker = attacker;
        }

        public final void setGunId(class_2960 gunId) {
            this.gunId = gunId;
        }

        public final void setBaseAmount(float baseAmount) {
            this.baseAmount = baseAmount;
        }

        public final void setDamageSource(GunDamageSourcePart part, class_1282 value) {
            if (this.logicalSide.isClient()) {
                throw new UnsupportedOperationException("DamageSource about gun hit is not available on client side!");
            }
            if (part == GunDamageSourcePart.ARMOR_PIERCING) {
                this.apPartDamageSource = value;
            } else {
                this.nonApPartDamageSource = value;
            }
        }

        public final void setHeadshot(boolean headshot) {
            this.isHeadShot = headshot;
        }

        public final void setHeadshotMultiplier(float headshotMultiplier) {
            this.headshotMultiplier = headshotMultiplier;
        }
    }
}

