/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.event.common;

import cn.sh1rocu.tacz.api.LogicalSide;
import cn.sh1rocu.tacz.api.event.BaseEvent;
import com.tacz.guns.api.event.common.GunDamageSourcePart;
import com.tacz.guns.api.event.common.KubeJSGunEventPoster;
import java.util.Optional;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;

public class EntityKillByGunEvent
extends BaseEvent
implements KubeJSGunEventPoster<EntityKillByGunEvent> {
    private final class_1297 bullet;
    @Nullable
    private final class_1309 killedEntity;
    @Nullable
    private final class_1309 attacker;
    private final class_2960 gunId;
    private final class_2960 gunDisplayId;
    private final float baseDamage;
    private final class_1282 nonApPartDamageSource;
    private final class_1282 apPartDamageSource;
    private final boolean isHeadShot;
    private final float headshotMultiplier;
    private final LogicalSide logicalSide;
    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.post(event);
        }
    });

    public EntityKillByGunEvent(class_1297 bullet, @Nullable class_1309 hurtEntity, @Nullable class_1309 attacker, class_2960 gunId, class_2960 gunDisplayId, float baseDamage, @Nullable Pair<class_1282, class_1282> sources, boolean isHeadShot, float headshotMultiplier, LogicalSide logicalSide) {
        this.bullet = bullet;
        this.killedEntity = hurtEntity;
        this.attacker = attacker;
        this.gunId = gunId;
        this.gunDisplayId = gunDisplayId;
        this.baseDamage = baseDamage;
        this.nonApPartDamageSource = Optional.ofNullable(sources).map(Pair::getLeft).orElse(null);
        this.apPartDamageSource = Optional.ofNullable(sources).map(Pair::getRight).orElse(null);
        this.isHeadShot = isHeadShot;
        this.headshotMultiplier = headshotMultiplier;
        this.logicalSide = logicalSide;
        this.postEventToKubeJS(this);
    }

    public class_1297 getBullet() {
        return this.bullet;
    }

    @Nullable
    public class_1309 getKilledEntity() {
        return this.killedEntity;
    }

    @Nullable
    public class_1309 getAttacker() {
        return this.attacker;
    }

    public class_2960 getGunId() {
        return this.gunId;
    }

    public float getBaseDamage() {
        return this.baseDamage;
    }

    public class_1282 getDamageSource(GunDamageSourcePart part) {
        if (this.logicalSide.isClient()) {
            throw new UnsupportedOperationException("DamageSource about gun hit is not available on client side!");
        }
        return part == GunDamageSourcePart.ARMOR_PIERCING ? this.apPartDamageSource : this.nonApPartDamageSource;
    }

    public boolean isHeadShot() {
        return this.isHeadShot;
    }

    public float getHeadshotMultiplier() {
        return this.headshotMultiplier;
    }

    public LogicalSide getLogicalSide() {
        return this.logicalSide;
    }

    public class_2960 getGunDisplayId() {
        return this.gunDisplayId;
    }

    public static interface Callback {
        public void post(EntityKillByGunEvent var1);
    }
}

