/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item.builder;

import com.google.common.collect.Maps;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.builder.AttachmentItemBuilder;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.item.gun.GunItemManager;
import com.tacz.guns.init.ModItems;
import java.util.EnumMap;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;

public final class GunItemBuilder {
    private int count = 1;
    private int ammoCount = 0;
    private boolean heatData = false;
    private class_2960 gunId;
    private FireMode fireMode = FireMode.UNKNOWN;
    private boolean bulletInBarrel = false;
    private EnumMap<AttachmentType, class_2960> attachments = Maps.newEnumMap(AttachmentType.class);

    private GunItemBuilder() {
    }

    public static GunItemBuilder create() {
        return new GunItemBuilder();
    }

    public GunItemBuilder setCount(int count) {
        this.count = Math.max(count, 1);
        return this;
    }

    public GunItemBuilder setAmmoCount(int count) {
        this.ammoCount = Math.max(count, 0);
        return this;
    }

    public GunItemBuilder setId(class_2960 id) {
        this.gunId = id;
        return this;
    }

    public GunItemBuilder setFireMode(FireMode fireMode) {
        this.fireMode = fireMode;
        return this;
    }

    public GunItemBuilder setAmmoInBarrel(boolean ammoInBarrel) {
        this.bulletInBarrel = ammoInBarrel;
        return this;
    }

    public GunItemBuilder putAttachment(AttachmentType type, class_2960 attachmentId) {
        this.attachments.put(type, attachmentId);
        return this;
    }

    public GunItemBuilder putAllAttachment(EnumMap<AttachmentType, class_2960> attachments) {
        this.attachments = attachments;
        return this;
    }

    public GunItemBuilder setHeatData(boolean heatData) {
        this.heatData = heatData;
        return this;
    }

    public class_1799 forceBuild() {
        class_1799 gun = new class_1799((class_1935)ModItems.MODERN_KINETIC_GUN, this.count);
        class_1792 class_17922 = gun.method_7909();
        if (class_17922 instanceof IGun) {
            IGun iGun = (IGun)class_17922;
            iGun.setGunId(gun, this.gunId);
            iGun.setFireMode(gun, this.fireMode);
            iGun.setCurrentAmmoCount(gun, this.ammoCount);
            iGun.setBulletInBarrel(gun, this.bulletInBarrel);
            if (this.heatData) {
                iGun.setHeatAmount(gun, 0.0f);
            }
            this.attachments.forEach((type, id) -> {
                class_1799 attachmentStack = AttachmentItemBuilder.create().setId((class_2960)id).build();
                iGun.installAttachment(gun, attachmentStack);
            });
        }
        return gun;
    }

    public class_1799 build() {
        String itemType = TimelessAPI.getCommonGunIndex(this.gunId).map(index -> index.getPojo().getItemType()).orElse(null);
        if (itemType == null) {
            return class_1799.field_8037;
        }
        AbstractGunItem gunItemRegistryObject = GunItemManager.getGunItemRegistryObject(itemType);
        if (gunItemRegistryObject == null) {
            return class_1799.field_8037;
        }
        class_1799 gun = new class_1799((class_1935)gunItemRegistryObject, this.count);
        class_1792 class_17922 = gun.method_7909();
        if (class_17922 instanceof IGun) {
            IGun iGun = (IGun)class_17922;
            iGun.setGunId(gun, this.gunId);
            iGun.setFireMode(gun, this.fireMode);
            iGun.setCurrentAmmoCount(gun, this.ammoCount);
            iGun.setBulletInBarrel(gun, this.bulletInBarrel);
            this.attachments.forEach((type, id) -> {
                class_1799 attachmentStack = AttachmentItemBuilder.create().setId((class_2960)id).build();
                iGun.installAttachment(gun, attachmentStack);
            });
        }
        return gun;
    }
}

