/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item.gun;

import cn.sh1rocu.tacz.api.extension.IItem;
import cn.sh1rocu.tacz.util.itemhandler.IItemHandler;
import cn.sh1rocu.tacz.util.itemhandler.ItemHandlerHelper;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.IAnimationItem;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.builder.AmmoItemBuilder;
import com.tacz.guns.api.item.builder.GunItemBuilder;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.client.renderer.item.GunItemRendererWrapper;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.inventory.tooltip.GunTooltip;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.FeedType;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.AllowAttachmentTagMatcher;
import com.tacz.guns.util.AttachmentDataUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5632;
import net.minecraft.class_756;

public abstract class AbstractGunItem
extends class_1792
implements IGun,
IAnimationItem,
IItem {
    protected AbstractGunItem(class_1792.class_1793 pProperties) {
        super(pProperties);
    }

    private static Comparator<Map.Entry<class_2960, CommonGunIndex>> idNameSort() {
        return Comparator.comparingInt(m -> ((CommonGunIndex)m.getValue()).getSort());
    }

    public abstract boolean startBolt(ShooterDataHolder var1, class_1799 var2, class_1309 var3);

    public abstract boolean tickBolt(ShooterDataHolder var1, class_1799 var2, class_1309 var3);

    public abstract void shoot(ShooterDataHolder var1, class_1799 var2, Supplier<Float> var3, Supplier<Float> var4, class_1309 var5);

    public abstract boolean startReload(ShooterDataHolder var1, class_1799 var2, class_1309 var3);

    public abstract ReloadState tickReload(ShooterDataHolder var1, class_1799 var2, class_1309 var3);

    public abstract void interruptReload(ShooterDataHolder var1, class_1799 var2, class_1309 var3);

    public abstract void fireSelect(ShooterDataHolder var1, class_1799 var2);

    public abstract void melee(ShooterDataHolder var1, class_1309 var2, class_1799 var3);

    public void tickHeat(ShooterDataHolder dataHolder, class_1799 gunItem, class_1309 shooter) {
    }

    public void doBulletSpread(ShooterDataHolder dataHolder, class_1799 gunItem, class_1309 shooter, class_1676 projectile, int bulletCnt, float processedSpeed, float inaccuracy, float pitch, float yaw) {
        projectile.method_24919((class_1297)shooter, pitch, yaw, 0.0f, processedSpeed, inaccuracy);
    }

    public boolean canReload(class_1309 shooter, class_1799 gunItem) {
        int maxAmmoCount;
        class_2960 gunId = this.getGunId(gunItem);
        CommonGunIndex gunIndex = TimelessAPI.getCommonGunIndex(gunId).orElse(null);
        if (gunIndex == null) {
            return false;
        }
        int currentAmmoCount = this.getCurrentAmmoCount(gunItem);
        if (currentAmmoCount >= (maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(gunItem, gunIndex.getGunData()))) {
            return false;
        }
        if (this.useInventoryAmmo(gunItem)) {
            return false;
        }
        if (gunIndex.getGunData().getReloadData().isInfinite()) {
            return true;
        }
        if (this.useDummyAmmo(gunItem)) {
            return this.getDummyAmmoAmount(gunItem) > 0;
        }
        return shooter.tacz$getItemHandler(null).map(cap -> {
            for (int i = 0; i < cap.getSlots(); ++i) {
                IAmmoBox iAmmoBox;
                IAmmo iAmmo;
                class_1799 checkAmmoStack = cap.getStackInSlot(i);
                class_1792 patt0$temp = checkAmmoStack.method_7909();
                if (patt0$temp instanceof IAmmo && (iAmmo = (IAmmo)patt0$temp).isAmmoOfGun(gunItem, checkAmmoStack)) {
                    return true;
                }
                class_1792 patt1$temp = checkAmmoStack.method_7909();
                if (!(patt1$temp instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)patt1$temp).isAmmoBoxOfGun(gunItem, checkAmmoStack)) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    @Override
    public void dropAllAmmo(class_1657 player, class_1799 gunItem) {
        if (this.useInventoryAmmo(gunItem)) {
            return;
        }
        int ammoCount = this.getCurrentAmmoCount(gunItem);
        if (ammoCount <= 0) {
            return;
        }
        class_2960 gunId = this.getGunId(gunItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(index -> {
            if (this.useDummyAmmo(gunItem)) {
                this.setCurrentAmmoCount(gunItem, 0);
                if (index.getGunData().getReloadData().getType().equals((Object)FeedType.FUEL)) {
                    return;
                }
                this.addDummyAmmoAmount(gunItem, ammoCount);
                return;
            }
            class_2960 ammoId = index.getGunData().getAmmoId();
            if (player.method_7337()) {
                int maxAmmCount = AttachmentDataUtils.getAmmoCountWithAttachment(gunItem, index.getGunData());
                this.setCurrentAmmoCount(gunItem, maxAmmCount);
                return;
            }
            if (index.getGunData().getReloadData().getType().equals((Object)FeedType.FUEL)) {
                this.setCurrentAmmoCount(gunItem, 0);
                return;
            }
            TimelessAPI.getCommonAmmoIndex(ammoId).ifPresent(ammoIndex -> {
                int stackSize = ammoIndex.getStackSize();
                int tmpAmmoCount = ammoCount;
                int roundCount = tmpAmmoCount / (stackSize + 1);
                for (int i = 0; i <= roundCount; ++i) {
                    int count = Math.min(tmpAmmoCount, stackSize);
                    class_1799 ammoItem = AmmoItemBuilder.create().setId(ammoId).setCount(count).build();
                    ItemHandlerHelper.giveItemToPlayer(player, ammoItem);
                    tmpAmmoCount -= stackSize;
                }
                this.setCurrentAmmoCount(gunItem, 0);
            });
        });
    }

    @Deprecated
    public int findAndExtractInventoryAmmos(IItemHandler itemHandler, class_1799 gunItem, int needAmmoCount) {
        return this.findAndExtractInventoryAmmo(itemHandler, gunItem, needAmmoCount);
    }

    public int findAndExtractInventoryAmmo(IItemHandler itemHandler, class_1799 gunItem, int needAmmoCount) {
        class_1792 extractItem;
        IAmmo iAmmo;
        class_1799 checkAmmoStack;
        class_1792 class_17922;
        int cnt = needAmmoCount;
        for (int i = 0; !(i >= itemHandler.getSlots() || (class_17922 = (checkAmmoStack = itemHandler.getStackInSlot(i)).method_7909()) instanceof IAmmo && (iAmmo = (IAmmo)class_17922).isAmmoOfGun(gunItem, checkAmmoStack) && (cnt -= (extractItem = itemHandler.extractItem(i, cnt, false)).method_7947()) <= 0); ++i) {
            IAmmoBox iAmmoBox;
            extractItem = checkAmmoStack.method_7909();
            if (!(extractItem instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)extractItem).isAmmoBoxOfGun(gunItem, checkAmmoStack)) continue;
            int boxAmmoCount = iAmmoBox.getAmmoCount(checkAmmoStack);
            int extractCount = Math.min(boxAmmoCount, cnt);
            int remainCount = boxAmmoCount - extractCount;
            iAmmoBox.setAmmoCount(checkAmmoStack, remainCount);
            if (remainCount <= 0) {
                iAmmoBox.setAmmoId(checkAmmoStack, DefaultAssets.EMPTY_AMMO_ID);
            }
            if ((cnt -= extractCount) <= 0) break;
        }
        return needAmmoCount - cnt;
    }

    public int findAndExtractDummyAmmo(class_1799 gunItem, int needAmmoCount) {
        int dummyAmmoCount = this.getDummyAmmoAmount(gunItem);
        int extractCount = Math.min(dummyAmmoCount, needAmmoCount);
        this.addDummyAmmoAmount(gunItem, -extractCount);
        return extractCount;
    }

    @Override
    public boolean allowAttachment(class_1799 gun, class_1799 attachmentItem) {
        IAttachment iAttachment = IAttachment.getIAttachmentOrNull(attachmentItem);
        IGun iGun = IGun.getIGunOrNull(gun);
        if (iGun != null && iAttachment != null) {
            class_2960 gunId = iGun.getGunId(gun);
            class_2960 attachmentId = iAttachment.getAttachmentId(attachmentItem);
            return AllowAttachmentTagMatcher.match(gunId, attachmentId);
        }
        return false;
    }

    @Override
    public boolean allowAttachmentType(class_1799 gun, AttachmentType type) {
        IGun iGun = IGun.getIGunOrNull(gun);
        if (iGun != null) {
            return TimelessAPI.getCommonGunIndex(iGun.getGunId(gun)).map(gunIndex -> {
                List<AttachmentType> allowAttachments = gunIndex.getGunData().getAllowAttachments();
                if (allowAttachments == null) {
                    return false;
                }
                return allowAttachments.contains((Object)type);
            }).orElse(false);
        }
        return false;
    }

    @Nonnull
    @Environment(value=EnvType.CLIENT)
    public class_2561 method_7864(@Nonnull class_1799 stack) {
        class_2960 gunId = this.getGunId(stack);
        Optional<ClientGunIndex> gunIndex = TimelessAPI.getClientGunIndex(gunId);
        if (gunIndex.isPresent()) {
            return class_2561.method_43471((String)gunIndex.get().getName());
        }
        return super.method_7864(stack);
    }

    public static class_2371<class_1799> fillItemCategory(GunTabType type) {
        class_2371 stacks = class_2371.method_10211();
        TimelessAPI.getAllCommonGunIndex().stream().sorted(AbstractGunItem.idNameSort()).forEach(entry -> {
            String indexType;
            CommonGunIndex index = (CommonGunIndex)entry.getValue();
            GunData gunData = index.getGunData();
            String key = type.name().toLowerCase(Locale.US);
            if (key.equals(indexType = index.getType())) {
                class_1799 itemStack = GunItemBuilder.create().setId((class_2960)entry.getKey()).setFireMode(gunData.getFireModeSet().get(0)).setAmmoCount(gunData.getAmmoAmount()).setHeatData(gunData.hasHeatData()).setAmmoInBarrel(true).build();
                stacks.add((Object)itemStack);
            }
        });
        return stacks;
    }

    @Override
    public boolean tacz$onEntitySwing(class_1799 stack, class_1309 entity) {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_756 getCustomRenderer() {
        return GunItemRendererWrapper.INSTANCE.get();
    }

    @Nonnull
    public Optional<class_5632> method_32346(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof IGun) {
            IGun iGun = (IGun)class_17922;
            Optional<CommonGunIndex> optional = TimelessAPI.getCommonGunIndex(this.getGunId(stack));
            if (optional.isPresent()) {
                CommonGunIndex gunIndex = optional.get();
                class_2960 ammoId = gunIndex.getGunData().getAmmoId();
                return Optional.of(new GunTooltip(stack, iGun, ammoId, gunIndex));
            }
        }
        return Optional.empty();
    }

    @Override
    public boolean useInventoryAmmo(class_1799 gun) {
        if (gun.method_7909() instanceof IGun) {
            Optional<CommonGunIndex> gunIndexOptional = TimelessAPI.getCommonGunIndex(this.getGunId(gun));
            if (gunIndexOptional.isEmpty()) {
                return false;
            }
            CommonGunIndex gunIndex = gunIndexOptional.get();
            return gunIndex.getGunData().getReloadData().getType().equals((Object)FeedType.INVENTORY);
        }
        return false;
    }

    @Override
    public boolean hasInventoryAmmo(class_1309 shooter, class_1799 gun, boolean needCheckAmmo) {
        if (!this.useInventoryAmmo(gun)) {
            return false;
        }
        if (!needCheckAmmo) {
            return true;
        }
        if (this.useDummyAmmo(gun)) {
            return this.getDummyAmmoAmount(gun) > 0;
        }
        return shooter.tacz$getItemHandler(null).map(cap -> {
            for (int i = 0; i < cap.getSlots(); ++i) {
                IAmmoBox iAmmoBox;
                IAmmo iAmmo;
                class_1799 checkAmmoStack = cap.getStackInSlot(i);
                class_1792 patt0$temp = checkAmmoStack.method_7909();
                if (patt0$temp instanceof IAmmo && (iAmmo = (IAmmo)patt0$temp).isAmmoOfGun(gun, checkAmmoStack)) {
                    return true;
                }
                class_1792 patt1$temp = checkAmmoStack.method_7909();
                if (!(patt1$temp instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)patt1$temp).isAmmoBoxOfGun(gun, checkAmmoStack)) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    @Override
    public int getRPM(class_1799 gun) {
        class_1792 class_17922 = gun.method_7909();
        if (class_17922 instanceof IGun) {
            IGun iGun = (IGun)class_17922;
            return TimelessAPI.getCommonGunIndex(this.getGunId(gun)).map(CommonGunIndex::getGunData).map(gunData -> {
                FireMode fireMode = this.getFireMode(gun);
                int rpm = gunData.getRoundsPerMinute(fireMode);
                if (iGun.hasHeatData(gun)) {
                    rpm *= (int)iGun.lerpRPM(gun);
                }
                return rpm;
            }).orElse(300);
        }
        return 300;
    }

    @Override
    public boolean isCanCrawl(class_1799 gun) {
        if (gun.method_7909() instanceof IGun) {
            return TimelessAPI.getCommonGunIndex(this.getGunId(gun)).map(CommonGunIndex::getGunData).map(GunData::isCanCrawl).orElse(false);
        }
        return false;
    }

    @Override
    public boolean isSame(class_1799 i, class_1799 j) {
        IGun iGun1 = IGun.getIGunOrNull(i);
        IGun iGun2 = IGun.getIGunOrNull(j);
        if (iGun1 != null && iGun2 != null) {
            return iGun1.getGunId(i).equals((Object)iGun2.getGunId(j));
        }
        if (i.method_7960() || j.method_7960()) {
            return i.method_7960() && j.method_7960();
        }
        return class_1799.method_7973((class_1799)i, (class_1799)j);
    }
}

