/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource.index;

import com.google.common.base.Preconditions;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.pojo.display.gun.GunDisplay;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.pojo.GunIndexPOJO;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ClientGunIndex {
    private String name;
    private GunData gunData;
    private String type;
    private String itemType;
    private GunDisplayInstance display;

    private ClientGunIndex() {
    }

    public static ClientGunIndex getInstance(GunIndexPOJO gunIndexPOJO) throws IllegalArgumentException {
        ClientGunIndex index = new ClientGunIndex();
        ClientGunIndex.checkIndex(gunIndexPOJO, index);
        GunDisplay display = ClientGunIndex.checkDisplay(gunIndexPOJO);
        ClientGunIndex.checkData(gunIndexPOJO, index);
        ClientGunIndex.checkName(gunIndexPOJO, index);
        index.display = GunDisplayInstance.create(display);
        return index;
    }

    private static void checkIndex(GunIndexPOJO gunIndexPOJO, ClientGunIndex index) {
        Preconditions.checkArgument((gunIndexPOJO != null ? 1 : 0) != 0, (Object)"index object file is empty");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{gunIndexPOJO.getType()}), (Object)"index object missing type field");
        index.type = gunIndexPOJO.getType();
        index.itemType = gunIndexPOJO.getItemType();
    }

    private static void checkName(GunIndexPOJO gunIndexPOJO, ClientGunIndex index) {
        index.name = gunIndexPOJO.getName();
        if (StringUtils.isBlank((CharSequence)index.name)) {
            index.name = "custom.tacz.error.no_name";
        }
    }

    private static void checkData(GunIndexPOJO gunIndexPOJO, ClientGunIndex index) {
        class_2960 pojoData = gunIndexPOJO.getData();
        Preconditions.checkArgument((pojoData != null ? 1 : 0) != 0, (Object)"index object missing pojoData field");
        GunData data = CommonAssetsManager.get().getGunData(pojoData);
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"there is no corresponding data file");
        index.gunData = data;
    }

    @NotNull
    private static GunDisplay checkDisplay(GunIndexPOJO gunIndexPOJO) {
        class_2960 pojoDisplay = gunIndexPOJO.getDisplay();
        Preconditions.checkArgument((pojoDisplay != null ? 1 : 0) != 0, (Object)"index object missing display field");
        GunDisplay display = ClientAssetsManager.INSTANCE.getGunDisplay(pojoDisplay);
        Preconditions.checkArgument((display != null ? 1 : 0) != 0, (Object)"there is no corresponding display file");
        return display;
    }

    public String getType() {
        return this.type;
    }

    public String getItemType() {
        return this.itemType;
    }

    public String getName() {
        return this.name;
    }

    public GunData getGunData() {
        return this.gunData;
    }

    public GunDisplayInstance getDefaultDisplay() {
        return this.display;
    }
}

