/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.compat.jei.category;

import com.tacz.guns.crafting.GunSmithTableIngredient;
import com.tacz.guns.crafting.GunSmithTableRecipe;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class GunSmithTableCategory
implements IRecipeCategory<GunSmithTableRecipe> {
    private final class_2561 title;
    private final IDrawableStatic bgDraw;
    private final IDrawable slotDraw;
    private final IDrawable iconDraw;
    private final RecipeType<GunSmithTableRecipe> type;

    public GunSmithTableCategory(IGuiHelper guiHelper, class_1799 icon, RecipeType<GunSmithTableRecipe> type, class_2561 title) {
        this.bgDraw = guiHelper.createBlankDrawable(160, 40);
        this.slotDraw = guiHelper.getSlotDrawable();
        this.iconDraw = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)icon);
        this.type = type;
        this.title = title;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GunSmithTableRecipe recipe, IFocusGroup focuses) {
        class_1799 output = recipe.getOutput();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 3, 12).addItemStack(output)).setBackground(this.slotDraw, -1, -1);
        List<GunSmithTableIngredient> inputs = recipe.getInputs();
        int size = inputs.size();
        if (size < 7) {
            for (int i = 0; i < size; ++i) {
                int xOffset = 35 + 20 * i;
                int yOffset = 12;
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, xOffset, yOffset).addItemStacks(this.getInput(inputs, i))).setBackground(this.slotDraw, -1, -1);
            }
        } else {
            int yOffset;
            int xOffset;
            int i;
            for (i = 0; i < 6; ++i) {
                xOffset = 35 + 20 * i;
                yOffset = 2;
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, xOffset, yOffset).addItemStacks(this.getInput(inputs, i))).setBackground(this.slotDraw, -1, -1);
            }
            for (i = 6; i < size; ++i) {
                xOffset = 35 + 20 * (i - 6);
                yOffset = 22;
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, xOffset, yOffset).addItemStacks(this.getInput(inputs, i))).setBackground(this.slotDraw, -1, -1);
            }
        }
    }

    private List<class_1799> getInput(List<GunSmithTableIngredient> inputs, int index) {
        if (index < inputs.size()) {
            GunSmithTableIngredient ingredient = inputs.get(index);
            class_1799[] items = ingredient.getIngredient().method_8105();
            return Arrays.stream(items).map(stack -> stack.method_46651(ingredient.getCount())).toList();
        }
        return Collections.singletonList(class_1799.field_8037);
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.bgDraw;
    }

    public IDrawable getIcon() {
        return this.iconDraw;
    }

    public RecipeType<GunSmithTableRecipe> getRecipeType() {
        return this.type;
    }
}

