/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity.shooter;

import cn.sh1rocu.tacz.api.LogicalSide;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.event.common.GunMeleeEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.entity.shooter.LivingEntityDrawGun;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.event.ServerMessageGunMelee;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.attachment.MeleeData;
import com.tacz.guns.resource.pojo.data.gun.GunDefaultMeleeData;
import com.tacz.guns.resource.pojo.data.gun.GunMeleeData;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class LivingEntityMelee {
    private final class_1309 shooter;
    private final ShooterDataHolder data;
    private final LivingEntityDrawGun draw;

    public LivingEntityMelee(class_1309 shooter, ShooterDataHolder data, LivingEntityDrawGun draw) {
        this.shooter = shooter;
        this.data = data;
        this.draw = draw;
    }

    public void melee() {
        if (this.data.currentGunItem == null) {
            return;
        }
        if (this.draw.getDrawCoolDown() != 0L) {
            return;
        }
        if (this.data.isBolting) {
            return;
        }
        long coolDown = this.getMeleeCoolDown();
        if (coolDown != 0L) {
            return;
        }
        class_1799 currentGunItem = this.data.currentGunItem.get();
        GunMeleeEvent gunMeleeEvent = new GunMeleeEvent(this.shooter, currentGunItem, LogicalSide.SERVER);
        ((GunMeleeEvent.Callback)GunMeleeEvent.CALLBACK.invoker()).post(gunMeleeEvent);
        if (gunMeleeEvent.isCanceled()) {
            return;
        }
        NetworkHandler.sendToTrackingEntity(new ServerMessageGunMelee(this.shooter.method_5628(), currentGunItem), (class_1297)this.shooter);
        class_1792 class_17922 = currentGunItem.method_7909();
        if (class_17922 instanceof AbstractGunItem) {
            AbstractGunItem logicGun = (AbstractGunItem)class_17922;
            this.data.meleeTimestamp = System.currentTimeMillis();
            class_2960 muzzleId = logicGun.getAttachmentId(currentGunItem, AttachmentType.MUZZLE);
            MeleeData muzzleMeleeData = this.getMeleeData(muzzleId);
            if (muzzleMeleeData != null) {
                float prepTime = muzzleMeleeData.getPrepTime();
                this.data.meleePrepTickCount = (int)Math.max(0.0f, prepTime * 20.0f);
                return;
            }
            class_2960 stockId = logicGun.getAttachmentId(currentGunItem, AttachmentType.STOCK);
            MeleeData stockMeleeData = this.getMeleeData(stockId);
            if (stockMeleeData != null) {
                float prepTime = stockMeleeData.getPrepTime();
                this.data.meleePrepTickCount = (int)Math.max(0.0f, prepTime * 20.0f);
                return;
            }
            class_2960 gunId = logicGun.getGunId(currentGunItem);
            TimelessAPI.getCommonGunIndex(gunId).ifPresent(index -> {
                GunDefaultMeleeData defaultMeleeData = index.getGunData().getMeleeData().getDefaultMeleeData();
                if (defaultMeleeData == null) {
                    return;
                }
                float prepTime = defaultMeleeData.getPrepTime();
                this.data.meleePrepTickCount = (int)Math.max(0.0f, prepTime * 20.0f);
            });
        }
    }

    public void scheduleTickMelee() {
        if (this.data.meleePrepTickCount > 0) {
            --this.data.meleePrepTickCount;
            return;
        }
        if (this.data.meleePrepTickCount == 0) {
            this.data.meleePrepTickCount = -1;
            if (this.data.currentGunItem == null) {
                return;
            }
            class_1799 currentGunItem = this.data.currentGunItem.get();
            class_1792 class_17922 = currentGunItem.method_7909();
            if (class_17922 instanceof AbstractGunItem) {
                AbstractGunItem logicGun = (AbstractGunItem)class_17922;
                logicGun.melee(this.data, this.shooter, currentGunItem);
            }
        }
    }

    public long getMeleeCoolDown() {
        if (this.data.currentGunItem == null) {
            return 0L;
        }
        class_1799 currentGunItem = this.data.currentGunItem.get();
        class_1792 class_17922 = currentGunItem.method_7909();
        if (!(class_17922 instanceof IGun)) {
            return 0L;
        }
        IGun iGun = (IGun)class_17922;
        class_2960 gunId = iGun.getGunId(currentGunItem);
        Optional<CommonGunIndex> gunIndex = TimelessAPI.getCommonGunIndex(gunId);
        return gunIndex.map(index -> {
            GunMeleeData meleeData = index.getGunData().getMeleeData();
            class_2960 muzzleId = iGun.getAttachmentId(currentGunItem, AttachmentType.MUZZLE);
            MeleeData muzzleMeleeData = this.getMeleeData(muzzleId);
            if (muzzleMeleeData != null) {
                return this.getTotalCooldownTime(meleeData, muzzleMeleeData.getCooldown());
            }
            class_2960 stockId = iGun.getAttachmentId(currentGunItem, AttachmentType.STOCK);
            MeleeData stockMeleeData = this.getMeleeData(stockId);
            if (stockMeleeData != null) {
                return this.getTotalCooldownTime(meleeData, stockMeleeData.getCooldown());
            }
            GunDefaultMeleeData defaultMeleeData = meleeData.getDefaultMeleeData();
            float defaultMeleeCooldownTime = defaultMeleeData == null ? 0.0f : defaultMeleeData.getCooldown();
            return this.getTotalCooldownTime(meleeData, defaultMeleeCooldownTime);
        }).orElse(-1L);
    }

    private long getTotalCooldownTime(GunMeleeData meleeData, float extraCooldownTime) {
        float totalCooldownTime = meleeData.getCooldown() + extraCooldownTime;
        long coolDown = (long)(totalCooldownTime * 1000.0f) - (System.currentTimeMillis() - this.data.meleeTimestamp);
        if ((coolDown -= 5L) < 0L) {
            return 0L;
        }
        return coolDown;
    }

    @Nullable
    private MeleeData getMeleeData(class_2960 attachmentId) {
        if (DefaultAssets.isEmptyAttachmentId(attachmentId)) {
            return null;
        }
        return TimelessAPI.getCommonAttachmentIndex(attachmentId).map(index -> index.getData().getMeleeData()).orElse(null);
    }
}

