/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.modifier.custom;

import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.GunProperties;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.attachment.Modifier;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunFireModeAdjustData;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class AmmoSpeedModifier
implements IAttachmentModifier<Modifier, Float> {
    public static final String ID = GunProperties.AMMO_SPEED.name();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public JsonProperty<Modifier> readJson(String json) {
        Data data = (Data)CommonAssetsManager.GSON.fromJson(json, Data.class);
        return new BulletSpeedJsonProperty(data.getAmmoSpeed());
    }

    @Override
    public CacheValue<Float> initCache(class_1799 gunItem, GunData gunData) {
        IGun iGun = Objects.requireNonNull(IGun.getIGunOrNull(gunItem));
        FireMode fireMode = iGun.getFireMode(gunItem);
        GunFireModeAdjustData fireModeAdjustData = gunData.getFireModeAdjustData(fireMode);
        float speed = gunData.getBulletData().getSpeed();
        if (fireModeAdjustData != null) {
            speed += fireModeAdjustData.getSpeed();
        }
        return new CacheValue<Float>(Float.valueOf(speed));
    }

    @Override
    public void eval(List<Modifier> modifiers, CacheValue<Float> cache) {
        double eval = AttachmentPropertyManager.eval(modifiers, (double)cache.getValue().floatValue());
        cache.setValue(Float.valueOf((float)eval));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public List<IAttachmentModifier.DiagramsData> getPropertyDiagramsData(class_1799 gunItem, GunData gunData, AttachmentCacheProperty cacheProperty) {
        IGun iGun = Objects.requireNonNull(IGun.getIGunOrNull(gunItem));
        FireMode fireMode = iGun.getFireMode(gunItem);
        GunFireModeAdjustData fireModeAdjustData = gunData.getFireModeAdjustData(fireMode);
        float ammoSpeed = gunData.getBulletData().getSpeed();
        if (fireModeAdjustData != null) {
            ammoSpeed += fireModeAdjustData.getSpeed();
        }
        float modifiedAmmoSpeed = ((Float)cacheProperty.getCache(ID)).floatValue();
        float ammoSpeedModifier = modifiedAmmoSpeed - ammoSpeed;
        double ammoSpeedPercent = Math.min((double)ammoSpeed / 600.0, 1.0);
        double ammoSpeedModifierPercent = Math.min((double)ammoSpeedModifier / 600.0, 1.0);
        String titleKey = "gui.tacz.gun_refit.property_diagrams.ammo_speed";
        String positivelyString = String.format("%dm/s \u00a7a(+%d)", Math.round(modifiedAmmoSpeed), Math.round(ammoSpeedModifier));
        String negativelyString = String.format("%dm/s \u00a7c(%d)", Math.round(modifiedAmmoSpeed), Math.round(ammoSpeedModifier));
        String defaultString = String.format("%dm/s", Math.round(modifiedAmmoSpeed));
        boolean positivelyBetter = true;
        IAttachmentModifier.DiagramsData diagramsData = new IAttachmentModifier.DiagramsData(ammoSpeedPercent, ammoSpeedModifierPercent, Float.valueOf(ammoSpeedModifier), titleKey, positivelyString, negativelyString, defaultString, positivelyBetter);
        return Collections.singletonList(diagramsData);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int getDiagramsDataSize() {
        return 1;
    }

    public static class Data {
        @SerializedName(value="ammo_speed")
        @Nullable
        private Modifier ammoSpeed = null;

        @Nullable
        public Modifier getAmmoSpeed() {
            return this.ammoSpeed;
        }
    }

    public static class BulletSpeedJsonProperty
    extends JsonProperty<Modifier> {
        public BulletSpeedJsonProperty(Modifier value) {
            super(value);
        }

        @Override
        public void initComponents() {
            Modifier ammoSpeed = (Modifier)this.getValue();
            if (ammoSpeed != null) {
                double eval = AttachmentPropertyManager.eval(ammoSpeed, 300.0);
                if (eval > 300.0) {
                    this.components.add(class_2561.method_43471((String)"tooltip.tacz.attachment.ammo_speed.increase").method_27692(class_124.field_1060));
                } else if (eval < 300.0) {
                    this.components.add(class_2561.method_43471((String)"tooltip.tacz.attachment.ammo_speed.decrease").method_27692(class_124.field_1061));
                }
            }
        }
    }
}

