/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.modifier.custom;

import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.GunProperties;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.attachment.Modifier;
import com.tacz.guns.resource.pojo.data.gun.BulletData;
import com.tacz.guns.resource.pojo.data.gun.ExtraDamage;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunFireModeAdjustData;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3532;

public class ArmorIgnoreModifier
implements IAttachmentModifier<Modifier, Float> {
    public static final String ID = GunProperties.ARMOR_IGNORE.name();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public JsonProperty<Modifier> readJson(String json) {
        Data data = (Data)CommonAssetsManager.GSON.fromJson(json, Data.class);
        return new ArmorIgnoreJsonProperty(data.getArmorIgnore());
    }

    @Override
    public CacheValue<Float> initCache(class_1799 gunItem, GunData gunData) {
        IGun iGun = Objects.requireNonNull(IGun.getIGunOrNull(gunItem));
        FireMode fireMode = iGun.getFireMode(gunItem);
        BulletData bulletData = gunData.getBulletData();
        GunFireModeAdjustData fireModeAdjustData = gunData.getFireModeAdjustData(fireMode);
        ExtraDamage extraDamage = bulletData.getExtraDamage();
        float finalBase = extraDamage != null ? extraDamage.getArmorIgnore() : 0.0f;
        finalBase = fireModeAdjustData != null ? finalBase + fireModeAdjustData.getArmorIgnore() : finalBase;
        finalBase = (float)((double)finalBase * (Double)SyncConfig.ARMOR_IGNORE_BASE_MULTIPLIER.get());
        return new CacheValue<Float>(Float.valueOf(finalBase));
    }

    @Override
    public void eval(List<Modifier> modifiers, CacheValue<Float> cache) {
        double eval = AttachmentPropertyManager.eval(modifiers, (double)cache.getValue().floatValue());
        cache.setValue(Float.valueOf((float)eval));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public List<IAttachmentModifier.DiagramsData> getPropertyDiagramsData(class_1799 gunItem, GunData gunData, AttachmentCacheProperty cacheProperty) {
        IGun iGun = Objects.requireNonNull(IGun.getIGunOrNull(gunItem));
        FireMode fireMode = iGun.getFireMode(gunItem);
        BulletData bulletData = gunData.getBulletData();
        GunFireModeAdjustData fireModeAdjustData = gunData.getFireModeAdjustData(fireMode);
        ExtraDamage extraDamage = bulletData.getExtraDamage();
        float finalBase = extraDamage != null ? extraDamage.getArmorIgnore() : 0.0f;
        finalBase = fireModeAdjustData != null ? finalBase + fireModeAdjustData.getArmorIgnore() : finalBase;
        finalBase = (float)((double)finalBase * (Double)SyncConfig.ARMOR_IGNORE_BASE_MULTIPLIER.get());
        float modifiedValue = ((Float)cacheProperty.getCache(ID)).floatValue();
        float modifier = modifiedValue - finalBase;
        double percent = class_3532.method_15363((float)finalBase, (float)0.0f, (float)1.0f);
        double modifierPercent = class_3532.method_15363((float)modifier, (float)0.0f, (float)1.0f);
        String titleKey = "gui.tacz.gun_refit.property_diagrams.armor_ignore";
        String positivelyString = String.format("%.1f%% \u00a7a(+%.1f%%)", Float.valueOf(modifiedValue * 100.0f), Float.valueOf(modifier * 100.0f));
        String negativelyString = String.format("%.1f%% \u00a7c(%.1f%%)", Float.valueOf(modifiedValue * 100.0f), Float.valueOf(modifier * 100.0f));
        String defaultString = String.format("%.1f%%", Float.valueOf(modifiedValue * 100.0f));
        boolean positivelyBetter = true;
        IAttachmentModifier.DiagramsData diagramsData = new IAttachmentModifier.DiagramsData(percent, modifierPercent, Float.valueOf(modifier), titleKey, positivelyString, negativelyString, defaultString, positivelyBetter);
        return Collections.singletonList(diagramsData);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int getDiagramsDataSize() {
        return 1;
    }

    public static class Data {
        @SerializedName(value="armor_ignore")
        @Nullable
        private Modifier armorIgnore = null;

        @Nullable
        public Modifier getArmorIgnore() {
            return this.armorIgnore;
        }
    }

    public static class ArmorIgnoreJsonProperty
    extends JsonProperty<Modifier> {
        public ArmorIgnoreJsonProperty(Modifier value) {
            super(value);
        }

        @Override
        public void initComponents() {
            Modifier value = (Modifier)this.getValue();
            if (value != null) {
                double eval = AttachmentPropertyManager.eval(value, 0.5);
                if (eval > 0.5) {
                    this.components.add(class_2561.method_43471((String)"tooltip.tacz.attachment.armor_ignore.increase").method_27692(class_124.field_1060));
                } else if (eval < 0.5) {
                    this.components.add(class_2561.method_43471((String)"tooltip.tacz.attachment.armor_ignore.decrease").method_27692(class_124.field_1061));
                }
            }
        }
    }
}

