/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.fluids;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.common.fluids.FiniteFluid;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2402;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_8567;

public class FiniteLiquidBlock
extends class_2248
implements class_2263,
class_2402 {
    public static final class_265 STABLE_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final class_2758 MISSING_LEVELS = class_2741.field_12538;
    private final List<class_3610> stateCache;
    private final FiniteFluid fluid;
    public final int maxLevel;
    private boolean fluidStateCacheInitialized = false;

    public FiniteLiquidBlock(Supplier<? extends FiniteFluid> supplier, class_4970.class_2251 arg) {
        super(arg);
        this.fluid = supplier.get();
        this.maxLevel = this.fluid.maxLayers;
        assert (this.maxLevel <= 16);
        this.stateCache = Lists.newArrayList();
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)MISSING_LEVELS, (Comparable)Integer.valueOf(0)));
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        super.method_9496(state, level, pos, random);
    }

    public class_3610 method_9545(class_2680 state) {
        int i = (Integer)state.method_11654((class_2769)MISSING_LEVELS);
        if (!this.fluidStateCacheInitialized) {
            this.initFluidStateCache();
        }
        return this.stateCache.get(Math.min(i, this.maxLevel));
    }

    protected synchronized void initFluidStateCache() {
        if (!this.fluidStateCacheInitialized) {
            this.stateCache.add(this.fluid.makeState(this.maxLevel));
            for (int i = 1; i < this.maxLevel; ++i) {
                this.stateCache.add(this.fluid.makeState(this.maxLevel - i));
            }
            this.fluidStateCacheInitialized = true;
        }
    }

    public class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return context.method_16192(STABLE_SHAPE, pos, true) && (Integer)state.method_11654((class_2769)MISSING_LEVELS) == 0 && context.method_27866(level.method_8316(pos.method_10084()), state.method_26227()) ? STABLE_SHAPE : class_259.method_1073();
    }

    public boolean method_9542(class_2680 state) {
        return state.method_26227().method_15773();
    }

    public void method_9514(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        state.method_26227().method_15757((class_1937)level, pos, random);
    }

    public boolean method_9579(class_2680 state, class_1922 level, class_2338 pos) {
        return false;
    }

    public boolean method_9522(class_2680 state, class_2680 adjacentBlockState, class_2350 direction) {
        return adjacentBlockState.method_26227().method_15772().method_15780((class_3611)this.fluid);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11455;
    }

    public List<class_1799> method_9560(class_2680 arg, class_8567.class_8568 arg2) {
        return Collections.emptyList();
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return class_259.method_1073();
    }

    public void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState, boolean isMoving) {
        level.method_39281(pos, state.method_26227().method_15772(), this.fluid.method_15789((class_4538)level));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 currentPos, class_2338 neighborPos) {
        if (state.method_26227().method_15771() || neighborState.method_26227().method_15771()) {
            level.method_39281(currentPos, state.method_26227().method_15772(), this.fluid.method_15789((class_4538)level));
        }
        return super.method_9559(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
        level.method_39281(pos, state.method_26227().method_15772(), this.fluid.method_15789((class_4538)level));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{MISSING_LEVELS});
    }

    public class_1799 method_9700(class_1936 level, class_2338 pos, class_2680 state) {
        AtomicInteger currentLevel = new AtomicInteger(state.method_26227().method_15761());
        HashMap<class_2338, Integer> posList = new HashMap<class_2338, Integer>();
        posList.put(pos, 0);
        this.findConnectedFluids(level, pos, posList, currentLevel);
        if (currentLevel.get() < this.maxLevel) {
            return class_1799.field_8037;
        }
        for (Map.Entry entry : posList.entrySet()) {
            class_2338 p = (class_2338)entry.getKey();
            Integer value = (Integer)entry.getValue();
            if (value == 0) {
                level.method_8652(p, class_2246.field_10124.method_9564(), 11);
                continue;
            }
            level.method_8652(p, this.fluid.makeState(value).method_15759(), 11);
        }
        return new class_1799((class_1935)this.fluid.method_15774());
    }

    private void findConnectedFluids(class_1936 level, class_2338 pos, Map<class_2338, Integer> remainders, AtomicInteger currentLevel) {
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        queue.offer(pos);
        while (!queue.isEmpty()) {
            class_2338 currentPos = (class_2338)queue.poll();
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                int l;
                class_2680 state;
                if (currentLevel.get() >= this.maxLevel) {
                    return;
                }
                class_2338 newPos = currentPos.method_10093(direction);
                if (remainders.containsKey(newPos) || !((state = level.method_8320(newPos)).method_26204() instanceof FiniteLiquidBlock) || (l = state.method_26227().method_15761()) <= 0) continue;
                currentLevel.addAndGet(l);
                remainders.put(newPos, Math.max(0, currentLevel.get() - this.maxLevel));
                queue.offer(newPos);
            }
        }
    }

    public Optional<class_3414> method_32351() {
        return this.fluid.method_32359();
    }

    public boolean method_10310(class_1922 level, class_2338 pos, class_2680 state, class_3611 fluid) {
        return fluid == this.fluid;
    }

    public boolean method_10311(class_1936 level, class_2338 pos, class_2680 state, class_3610 fluidState) {
        int currentLevel = (Integer)state.method_11654((class_2769)MISSING_LEVELS);
        level.method_8652(pos, (class_2680)state.method_11657((class_2769)MISSING_LEVELS, (Comparable)((Integer)fluidState.method_15759().method_11654((class_2769)MISSING_LEVELS))), 3);
        return false;
    }
}

