/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CandleHolderBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlockGeneratorBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.NoticeBoardBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.common.worldgen.StructureLocator;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2510;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6880;
import net.minecraft.class_6908;

public class RoadSignFeature
extends class_3031<Config> {
    private static final class_2680 AIR = class_2246.field_10124.method_9564();
    private static final class_2680 PATH = class_2246.field_10194.method_9564();
    private static final class_2680 SANDSTONE_PATH = class_2246.field_10467.method_9564();

    public RoadSignFeature(Codec<Config> codec) {
        super(codec);
    }

    public static boolean isNotSolid(class_1936 world, class_2338 pos) {
        return !world.method_16358(pos, state -> state.method_26212((class_1922)world, pos));
    }

    public boolean method_13151(class_5821<Config> context) {
        class_5281 reader = context.method_33652();
        class_5819 rand = context.method_33654();
        class_2338 pos = context.method_33655();
        Config c = (Config)context.method_33656();
        pos = pos.method_10074();
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                for (int k = 1; k <= 4; ++k) {
                    if ((Math.abs(i) == 2 || Math.abs(j) == 2) && k == 1) continue;
                    reader.method_8652(pos.method_10069(i, k, j), ModRegistry.STRUCTURE_TEMP.get().method_9564(), 2);
                }
            }
        }
        float humidity = SuppPlatformStuff.getDownfall((class_1959)reader.method_23753(pos).comp_349());
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                reader.method_8652(pos.method_10069(i, -1, j), c.cobble, 2);
                class_2338 pathPos = pos.method_10069(i, 0, j);
                double dist = pos.method_10268((double)pathPos.method_10263(), (double)pathPos.method_10264(), (double)pathPos.method_10260()) / (double)5.2f;
                if ((double)rand.method_43057() < dist - 0.15) continue;
                boolean m = (double)humidity * 0.75 > (double)rand.method_43057();
                reader.method_8652(pathPos, m ? c.mossyCobble : c.cobble, 2);
            }
        }
        boolean m = (double)humidity * 0.75 > (double)rand.method_43057();
        pos = pos.method_10084();
        reader.method_8652(pos, m ? c.mossyWall : c.wall, 2);
        pos = pos.method_10084();
        reader.method_8652(pos, c.fence, 2);
        pos = pos.method_10084();
        reader.method_8652(pos, c.fence, 2);
        reader.method_8652(pos.method_10084(), ModRegistry.BLOCK_GENERATOR.get().method_9564(), 2);
        class_2586 class_25862 = reader.method_8321(pos.method_10084());
        if (class_25862 instanceof BlockGeneratorBlockTile) {
            BlockGeneratorBlockTile t = (BlockGeneratorBlockTile)class_25862;
            t.setConfig(c);
        } else {
            Supplementaries.LOGGER.error("Failed to get Road Sign Block Entity during generation. How did this happen?");
        }
        return true;
    }

    public static void applyPostProcess(Config c, class_3218 level, class_2338 generatorPos, List<StructureLocator.LocatedStruct> foundVillages) {
        RandomState r = c.randomState;
        class_2680 topState = c.trapdoor;
        class_2338 pos = generatorPos.method_10087(2);
        ArrayList<Pair> villages = new ArrayList<Pair>();
        for (StructureLocator.LocatedStruct f : foundVillages) {
            villages.add(Pair.of((Object)((int)class_3532.method_15355((float)((float)f.pos().method_10268((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260())))), (Object)f.pos()));
        }
        boolean inVillage = false;
        if (inVillage) {
            class_6880 b = level.method_23753(pos);
            class_2680 replace = b.method_40220(class_6908.field_36496) ? SANDSTONE_PATH : PATH;
            RoadSignFeature.replaceCobbleWithPath(c, (class_1937)level, pos, replace);
        }
        if (!villages.isEmpty()) {
            class_2338 village2;
            int dist2;
            class_2338 village1;
            int dist1;
            class_5819 rand = level.field_9229;
            boolean twoSigns = true;
            if (villages.size() == 1 || r.doubleSignChance > rand.method_43057() && (Integer)((Pair)villages.get(0)).getFirst() > 192) {
                dist1 = (Integer)((Pair)villages.get(0)).getFirst();
                village1 = (class_2338)((Pair)villages.get(0)).getSecond();
                dist2 = dist1;
                village2 = village1;
                twoSigns = false;
            } else {
                boolean inv = rand.method_43056();
                dist1 = (Integer)((Pair)villages.get(inv ? 0 : 1)).getFirst();
                village1 = (class_2338)((Pair)villages.get(inv ? 0 : 1)).getSecond();
                dist2 = (Integer)((Pair)villages.get(inv ? 1 : 0)).getFirst();
                village2 = (class_2338)((Pair)villages.get(inv ? 1 : 0)).getSecond();
            }
            level.method_8501(pos, ModRegistry.SIGN_POST.get().method_9564());
            class_2586 class_25862 = level.method_8321(pos);
            if (class_25862 instanceof SignPostBlockTile) {
                class_2350 backDir;
                float yaw;
                float diff;
                SignPostBlockTile tile = (SignPostBlockTile)class_25862;
                tile.setHeldBlock(c.fence);
                boolean left = rand.method_43056();
                SignPostBlockTile.Sign up = tile.getSignUp();
                SignPostBlockTile.Sign down = tile.getSignDown();
                up.setActive(true);
                up.setLeft(left);
                up.setWoodType(c.signWood);
                up.pointToward(tile.method_11016(), village1);
                down.setActive(twoSigns);
                down.setLeft(left);
                down.setWoodType(c.signWood);
                down.pointToward(tile.method_11016(), village2);
                if (Math.abs(up.yaw() - down.yaw()) > 90.0f) {
                    down.toggleDirection();
                    down.pointToward(tile.method_11016(), village2);
                }
                if (CommonConfigs.Building.WAY_SIGN_DISTANCE_TEXT.get().booleanValue()) {
                    tile.getTextHolder(0).setMessage(0, RoadSignFeature.getSignText(dist1));
                    if (twoSigns) {
                        tile.getTextHolder(1).setMessage(0, RoadSignFeature.getSignText(dist2));
                    }
                }
                class_2350 sideDir = (diff = class_3532.method_15381((float)(yaw = class_3532.method_15393((float)(90.0f + 360.0f * MthUtils.averageAngles((Float[])new Float[]{Float.valueOf((180.0f - up.yaw()) / 360.0f), Float.valueOf((180.0f - down.yaw()) / 360.0f)})))), (float)(backDir = class_2350.method_10150((double)yaw)).method_10144())) < 0.0f ? backDir.method_10170() : backDir.method_10160();
                ArrayList<class_2350> lampDir = new ArrayList<class_2350>();
                lampDir.add(backDir.method_10153());
                lampDir.add(backDir.method_10153());
                lampDir.add(backDir.method_10153());
                if (Math.abs(diff) > 30.0f) {
                    lampDir.add(sideDir.method_10153());
                }
                boolean hasGroundLantern = false;
                boolean hasFirefly = false;
                if (rand.method_43057() < r.stoneChance && class_3532.method_15356((float)(tile.getPointingYaw(true) + 180.0f), (float)yaw) > 70.0f) {
                    class_2338 stonePos = pos.method_10074().method_10081(backDir.method_10163());
                    if (rand.method_43056()) {
                        level.method_8652(stonePos, c.stoneSlab, 2);
                    } else {
                        level.method_8652(stonePos, (class_2680)c.stoneStairs.method_11657((class_2769)class_2510.field_11571, (Comparable)sideDir), 2);
                    }
                    stonePos = stonePos.method_10081(sideDir.method_10163());
                    level.method_8652(stonePos, c.stone, 2);
                    if (rand.method_43057() < r.stoneLanternChance) {
                        level.method_8652(stonePos.method_10084(), hasFirefly ? c.lanternDown : c.lanternDown, 3);
                        hasGroundLantern = true;
                    }
                    if (!RoadSignFeature.isNotSolid((class_1936)level, (stonePos = stonePos.method_10081(sideDir.method_10163())).method_10074())) {
                        if (rand.method_43056()) {
                            level.method_8652(stonePos, c.stoneSlab, 2);
                        } else {
                            level.method_8652(stonePos, (class_2680)c.stoneStairs.method_11657((class_2769)class_2510.field_11571, (Comparable)sideDir.method_10153()), 2);
                        }
                    }
                }
                if (!hasGroundLantern) {
                    class_2248 wl;
                    boolean doubleSided;
                    class_2680 light;
                    pos = pos.method_10086(2);
                    class_2680 class_26802 = light = hasFirefly ? c.lanternUp : c.lanternUp;
                    if (rand.method_43057() < r.candleHolderChance) {
                        light = (class_2680)((class_2680)c.candleHolder.method_11657((class_2769)CandleHolderBlock.LIT, (Comparable)Boolean.valueOf(true))).method_11657(CandleHolderBlock.FACE, (Comparable)class_2738.field_12473);
                    }
                    class_2350 dir = (class_2350)lampDir.get(rand.method_43048(lampDir.size()));
                    boolean bl = doubleSided = r.doubleLanternChance > rand.method_43057();
                    if (doubleSided) {
                        dir = dir.method_10170();
                    }
                    if ((wl = CompatObjects.WALL_LANTERN.get()) != null && rand.method_43057() < r.wallLanternChance) {
                        topState = rand.method_43057() < r.trapdoorChance ? c.trapdoor : AIR;
                        RoadSignFeature.placeWallLantern(c.lanternDown, level, dir, wl, pos.method_10074());
                        if (doubleSided) {
                            RoadSignFeature.placeWallLantern(c.lanternDown, level, dir.method_10153(), wl, pos.method_10074());
                        }
                    } else {
                        boolean isTrapdoor;
                        boolean bl2 = isTrapdoor = r.trapdoorChance > rand.method_43057();
                        if (!isTrapdoor) {
                            topState = c.fence;
                        }
                        if (doubleSided) {
                            class_2338 backPos = pos.method_10093(dir.method_10153());
                            level.method_8652(backPos, isTrapdoor ? c.trapdoor : c.fence, 2);
                            if (r.logChance > rand.method_43057()) {
                                topState = isTrapdoor ? c.slab : c.log;
                            }
                            level.method_8652(backPos.method_10074(), light, 3);
                        }
                        pos = pos.method_10093(dir);
                        class_2680 frontState = isTrapdoor ? c.trapdoor : c.fence;
                        level.method_8652(pos, frontState, 2);
                        level.method_8652(pos.method_10074(), light, 3);
                    }
                }
            }
        } else {
            class_1799 book = new class_1799((class_1935)class_1802.field_8674);
            class_2487 com = new class_2487();
            class_2499 listTag = new class_2499();
            listTag.add((Object)class_2519.method_23256((String)"nothing here but monsters\n\n\n"));
            com.method_10566("pages", (class_2520)listTag);
            book.method_7980(com);
            class_2338 belowPos = generatorPos.method_10087(2);
            level.method_8501(belowPos, (class_2680)((class_2680)ModRegistry.NOTICE_BOARD.get().method_9564().method_11657((class_2769)NoticeBoardBlock.HAS_BOOK, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)NoticeBoardBlock.FACING, (Comparable)class_2350.class_2353.field_11062.method_10183(level.field_9229)));
            class_2586 class_25863 = level.method_8321(belowPos);
            if (class_25863 instanceof NoticeBoardBlockTile) {
                NoticeBoardBlockTile board = (NoticeBoardBlockTile)class_25863;
                board.setDisplayedItem(book);
            }
        }
        level.method_8652(generatorPos, topState, 3);
    }

    private static class_2561 getSignText(int d) {
        int s = d < 100 ? 10 : (d < 2000 ? 100 : 1000);
        return class_2561.method_43469((String)"message.supplementaries.road_sign", (Object[])new Object[]{(d + s / 2) / s * s});
    }

    private static void replaceCobbleWithPath(Config c, class_1937 world, class_2338 pos, class_2680 path) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                class_2338 pathPos;
                class_2680 state;
                if (Math.abs(i) == 2 && Math.abs(j) == 2 || i == 0 && j == 0 || !(state = world.method_8320(pathPos = pos.method_10069(i, -2, j))).method_27852(c.cobble.method_26204()) && !state.method_27852(c.mossyCobble.method_26204())) continue;
                world.method_8652(pathPos, path, 2);
            }
        }
    }

    private static void placeWallLantern(class_2680 lanternState, class_3218 level, class_2350 dir, class_2248 wallLantern, class_2338 pos) {
        class_2586 class_25862;
        pos = pos.method_10093(dir);
        class_2680 state = wallLantern.method_9605(new class_1750((class_1937)level, null, class_1268.field_5808, wallLantern.method_8389().method_7854(), new class_3965(pos.method_46558(), dir, pos, false)));
        if (state != null) {
            level.method_8501(pos, state);
        }
        if ((class_25862 = level.method_8321(pos)) instanceof IBlockHolder) {
            IBlockHolder tt = (IBlockHolder)class_25862;
            tt.setHeldBlock(lanternState);
        }
    }

    public record Config(RandomState randomState, WoodType postWood, WoodType signWood, class_2680 fence, class_2680 trapdoor, class_2680 slab, class_2680 log, class_2680 cobble, class_2680 mossyCobble, class_2680 wall, class_2680 mossyWall, class_2680 lanternUp, class_2680 lanternDown, class_2680 candleHolder, class_2680 stone, class_2680 stoneSlab, class_2680 stoneStairs, String invalidMessage) implements class_3037
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RandomState.CODEC.fieldOf("random_state").forGetter(Config::randomState), (App)WoodType.CODEC.fieldOf("post_wood").forGetter(Config::postWood), (App)WoodType.CODEC.fieldOf("sign_wood").forGetter(Config::signWood), (App)class_2680.field_24734.fieldOf("cobble").forGetter(Config::cobble), (App)class_2680.field_24734.fieldOf("mossy_cobble").forGetter(Config::mossyCobble), (App)class_2680.field_24734.fieldOf("wall").forGetter(Config::wall), (App)class_2680.field_24734.fieldOf("mossy_wall").forGetter(Config::mossyWall), (App)class_2680.field_24734.fieldOf("lantern_up").forGetter(Config::lanternUp), (App)class_2680.field_24734.fieldOf("lantern_down").forGetter(Config::lanternDown), (App)class_2680.field_24734.fieldOf("candle_holder").forGetter(Config::candleHolder), (App)class_2680.field_24734.fieldOf("stone").forGetter(Config::stone), (App)class_2680.field_24734.fieldOf("stone_slab").forGetter(Config::stoneSlab), (App)class_2680.field_24734.fieldOf("stone_stairs").forGetter(Config::stoneStairs)).apply((Applicative)instance, Config::of)).comapFlatMap(s -> {
            if (s.invalidMessage != null) {
                return DataResult.error(() -> s.invalidMessage);
            }
            return DataResult.success((Object)s);
        }, Function.identity());

        private static Config of(RandomState randomState, WoodType postWood, WoodType signWood, class_2680 cobble, class_2680 mossyCobble, class_2680 wall, class_2680 mossyWall, class_2680 lanternUp, class_2680 lanternDown, class_2680 candleHolder, class_2680 stone, class_2680 stoneSlab, class_2680 stoneStairs) {
            class_2248 log;
            class_2248 slab;
            class_2248 trapdoor;
            Object message = null;
            class_2248 fence = postWood.getBlockOfThis("fence");
            if (fence == null) {
                message = "Post wood type does not have a fence";
                fence = class_2246.field_10124;
            }
            if ((trapdoor = postWood.getBlockOfThis("trapdoor")) == null) {
                message = "Post wood type does not have a trapdoor";
                trapdoor = class_2246.field_10124;
            }
            if ((slab = postWood.getBlockOfThis("slab")) == null) {
                message = "Post wood type does not have a slab";
                slab = class_2246.field_10124;
            }
            if ((log = postWood.getBlockOfThis("stripped_log")) == null) {
                message = "Post wood type does not have a valid stripped log";
                log = class_2246.field_10124;
            }
            if (!(stoneSlab.method_26204() instanceof class_2482)) {
                message = "Stone slab must be a SlabBlock, was " + String.valueOf(stoneSlab);
            }
            if (!(stoneStairs.method_26204() instanceof class_2510)) {
                message = "Stone slab must be a StairBlock, was " + String.valueOf(stoneStairs);
            }
            if (!candleHolder.method_28498(CandleHolderBlock.FACE) || !candleHolder.method_28498((class_2769)CandleHolderBlock.LIT)) {
                message = "Candle holder block has to have a face and lit property";
            }
            return new Config(randomState, postWood, signWood, fence.method_9564(), trapdoor.method_9564(), slab.method_9564(), log.method_9564(), cobble, mossyCobble, wall, mossyWall, lanternUp, lanternDown, candleHolder, stone, stoneSlab, stoneStairs, (String)message);
        }
    }

    private record RandomState(float doubleSignChance, float stoneChance, float stoneLanternChance, float candleHolderChance, float wallLanternChance, float doubleLanternChance, float trapdoorChance, float logChance) {
        public static final Codec<RandomState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("double_sign_chance").forGetter(RandomState::doubleSignChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("stone_chance").forGetter(RandomState::stoneChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("stone_lantern_chance").forGetter(RandomState::stoneLanternChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("candle_holder_chance").forGetter(RandomState::candleHolderChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("wall_lantern_chance").forGetter(RandomState::wallLanternChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("double_lantern_chance").forGetter(RandomState::doubleLanternChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("trapdoor_chance").forGetter(RandomState::trapdoorChance), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("log_chance").forGetter(RandomState::logChance)).apply((Applicative)instance, RandomState::new));
    }
}

