/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.misc.StrOpt;
import net.mehvahdjukaar.moonlight.api.misc.WeakHashSet;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.mehvahdjukaar.supplementaries.reg.ModWorldgenRegistry;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_4966;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7151;
import net.minecraft.class_7924;

public class WaySignStructure
extends class_3195 {
    public static final Codec<WaySignStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WaySignStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)StrOpt.of((Codec)class_2960.field_25139, (String)"start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.INT.fieldOf("min_y").forGetter(structure -> structure.minY), (App)Codec.INT.fieldOf("max_y").forGetter(structure -> structure.maxY)).apply((Applicative)instance, WaySignStructure::new)).codec();
    private final class_6880<class_3785> startPool;
    private final Optional<class_2960> startJigsawName;
    private final int minY;
    private final int maxY;
    private static final Set<class_6880<class_1959>> VALID_BIOMES = new WeakHashSet();

    public WaySignStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int minY, int maxY) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.minY = minY;
        this.maxY = maxY;
    }

    public class_7151<?> method_41618() {
        return ModWorldgenRegistry.WAY_SIGN.get();
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        Optional<class_2338> suitablePosition = WaySignStructure.getSuitablePosition(context, this);
        if (suitablePosition.isEmpty()) {
            return Optional.empty();
        }
        class_2338 blockPos = suitablePosition.get();
        return class_3778.method_30419((class_3195.class_7149)context, this.startPool, this.startJigsawName, (int)3, (class_2338)blockPos, (boolean)false, Optional.empty(), (int)32);
    }

    private static Optional<class_2338> getSuitablePosition(class_3195.class_7149 context, WaySignStructure structure) {
        int z;
        class_1923 chunkPos = context.comp_568();
        class_2794 generator = context.comp_562();
        class_5539 levelHeightAccessor = context.comp_569();
        class_7138 randomState = context.comp_564();
        Set biomes = context.comp_563().method_28443();
        boolean hasVillages = false;
        for (class_6880<class_1959> v : VALID_BIOMES) {
            if (!biomes.contains(v)) continue;
            hasVillages = true;
            break;
        }
        if (!hasVillages) {
            return Optional.empty();
        }
        int x = chunkPos.method_33940();
        int y = generator.method_18028(x, z = chunkPos.method_33942(), class_2902.class_2903.field_13194, levelHeightAccessor, randomState);
        if (y < structure.minY || y > structure.maxY) {
            return Optional.empty();
        }
        if (y > 105 || y < generator.method_16398()) {
            return Optional.empty();
        }
        IntArrayList list = new IntArrayList();
        list.add(y);
        if (WaySignStructure.isPosNotValid(generator, x + 2, z + 2, (IntList)list, levelHeightAccessor, randomState)) {
            return Optional.empty();
        }
        if (WaySignStructure.isPosNotValid(generator, x + 2, z - 2, (IntList)list, levelHeightAccessor, randomState)) {
            return Optional.empty();
        }
        if (WaySignStructure.isPosNotValid(generator, x - 2, z + 2, (IntList)list, levelHeightAccessor, randomState)) {
            return Optional.empty();
        }
        if (WaySignStructure.isPosNotValid(generator, x - 2, z - 2, (IntList)list, levelHeightAccessor, randomState)) {
            return Optional.empty();
        }
        IntRBTreeSet set = new IntRBTreeSet((IntCollection)list);
        if (set.lastInt() - set.firstInt() > 1) {
            return Optional.empty();
        }
        int sum = 0;
        for (Integer v : list) {
            sum += v.intValue();
        }
        return Optional.of(new class_2338(x, Math.round((float)sum / 5.0f) + 1, z));
    }

    private static boolean isPosNotValid(class_2794 gen, int x, int z, IntList heightMap, class_5539 heightLimitView, class_7138 randomState) {
        int y = gen.method_18028(x, z, class_2902.class_2903.field_13194, heightLimitView, randomState);
        class_4966 noisecolumn = gen.method_26261(x, z, heightLimitView, randomState);
        class_2680 state = noisecolumn.method_32892(y);
        try {
            if (state.method_26227().method_15769()) {
                heightMap.add(y);
                return false;
            }
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    public static void recomputeValidStructureCache(class_5455 access) {
        for (class_6880 s : access.method_30530(class_7924.field_41246).method_40286(ModTags.WAY_SIGN_DESTINATIONS)) {
            VALID_BIOMES.addAll(((class_3195)s.comp_349()).method_41607().method_40239().toList());
        }
    }

    public static void clearCache() {
        VALID_BIOMES.clear();
    }

    public static class Type
    implements class_7151<WaySignStructure> {
        public Codec<WaySignStructure> codec() {
            return CODEC;
        }
    }
}

