/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable;

import artifacts.client.ToggleKeyHandler;
import artifacts.item.ArtifactItem;
import artifacts.item.wearable.ArtifactAttributeModifier;
import artifacts.platform.PlatformServices;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public abstract class WearableArtifactItem
extends ArtifactItem {
    private final List<ArtifactAttributeModifier> attributeModifiers = new ArrayList<ArtifactAttributeModifier>();

    public WearableArtifactItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public WearableArtifactItem() {
        this(new class_1792.class_1793());
    }

    public void addAttributeModifier(ArtifactAttributeModifier attributeModifier) {
        this.attributeModifiers.add(attributeModifier);
    }

    public List<ArtifactAttributeModifier> getAttributeModifiers() {
        return this.attributeModifiers;
    }

    public boolean isEquippedBy(@Nullable class_1309 entity) {
        return PlatformServices.platformHelper.isEquippedBy(entity, this);
    }

    public Stream<class_1799> findAllEquippedBy(class_1309 entity) {
        return PlatformServices.platformHelper.findAllEquippedBy(entity, this);
    }

    public void onEquip(class_1309 entity, class_1799 stack) {
        if (entity.method_37908().method_8608()) {
            return;
        }
        for (ArtifactAttributeModifier modifier : this.attributeModifiers) {
            class_1324 attributeInstance = entity.method_5996(modifier.getAttribute());
            if (attributeInstance == null) continue;
            attributeInstance.method_6200(modifier.getModifierId());
            class_1322 attributeModifier = modifier.createModifier();
            attributeInstance.method_26837(attributeModifier);
            modifier.onAttributeUpdated(entity);
        }
    }

    public void onUnequip(class_1309 entity, class_1799 stack) {
        if (entity.method_37908().method_8608()) {
            return;
        }
        for (ArtifactAttributeModifier modifier : this.attributeModifiers) {
            class_1324 attributeInstance = entity.method_5996(modifier.getAttribute());
            if (attributeInstance == null) continue;
            attributeInstance.method_6200(modifier.getModifierId());
            modifier.onAttributeUpdated(entity);
        }
    }

    public void wornTick(class_1309 entity, class_1799 stack) {
        if (entity.method_37908().method_8608()) {
            return;
        }
        for (ArtifactAttributeModifier modifier : this.attributeModifiers) {
            class_1322 existingModifier;
            class_1324 attributeInstance = entity.method_5996(modifier.getAttribute());
            if (attributeInstance == null || (existingModifier = attributeInstance.method_6199(modifier.getModifierId())) != null && existingModifier.method_6186() == modifier.getAmount()) continue;
            attributeInstance.method_6200(modifier.getModifierId());
            attributeInstance.method_26837(modifier.createModifier());
            modifier.onAttributeUpdated(entity);
        }
    }

    @Override
    public final boolean isCosmetic() {
        for (ArtifactAttributeModifier modifier : this.attributeModifiers) {
            if (modifier.getAmount() == 0.0) continue;
            return false;
        }
        return this.getFortuneLevel() == 0 && this.getLootingLevel() == 0 && !this.canWalkOnPowderedSnow() && !this.hasNonCosmeticEffects();
    }

    protected boolean hasNonCosmeticEffects() {
        return false;
    }

    public class_3414 getEquipSound() {
        return class_3417.field_14883;
    }

    public int getFortuneLevel() {
        return 0;
    }

    public int getLootingLevel() {
        return 0;
    }

    public boolean makesPiglinsNeutral() {
        return false;
    }

    public boolean canWalkOnPowderedSnow() {
        return false;
    }

    public void toggleItem(class_3222 player) {
        this.findAllEquippedBy((class_1309)player).forEach(stack -> WearableArtifactItem.setActivated(stack, !WearableArtifactItem.isActivated(stack)));
    }

    public static boolean isActivated(class_1799 stack) {
        return !stack.method_7985() || !stack.method_7948().method_10545("isActivated") || stack.method_7948().method_10577("isActivated");
    }

    public static void setActivated(class_1799 stack, boolean active) {
        stack.method_7948().method_10556("isActivated", active);
    }

    @Override
    protected void addEffectsTooltip(class_1799 stack, List<class_5250> tooltip) {
        super.addEffectsTooltip(stack, tooltip);
        class_304 key = ToggleKeyHandler.getToggleKey(this);
        if (!(key == null || key.method_1415() && WearableArtifactItem.isActivated(stack))) {
            tooltip.add(class_2561.method_43469((String)"%s.tooltip.toggle_keymapping".formatted("artifacts"), (Object[])new Object[]{key.method_16007()}));
        }
    }
}

