/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.hands;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModGameRules;
import artifacts.registry.ModItems;
import artifacts.registry.ModTags;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;

public class DiggingClawsItem
extends WearableArtifactItem {
    @Override
    public boolean hasNonCosmeticEffects() {
        return DiggingClawsItem.getToolTier().isPresent() || ModGameRules.DIGGING_CLAWS_DIG_SPEED_BONUS.get() > 0.0;
    }

    @Override
    protected void addEffectsTooltip(class_1799 stack, List<class_5250> tooltip) {
        DiggingClawsItem.getToolTier().ifPresent(tier -> tooltip.add(this.tooltipLine("mining_level", class_2561.method_43471((String)"%s.tooltip.tool_tier.%s".formatted("artifacts", tier.method_8024() + 1)))));
        if (ModGameRules.DIGGING_CLAWS_DIG_SPEED_BONUS.get() > 0.0) {
            tooltip.add(this.tooltipLine("mining_speed", new Object[0]));
        }
    }

    public static Optional<class_1832> getToolTier() {
        return switch (ModGameRules.DIGGING_CLAWS_TOOL_TIER.get()) {
            case 0 -> Optional.empty();
            case 1 -> Optional.of(class_1834.field_8922);
            case 2 -> Optional.of(class_1834.field_8927);
            case 3 -> Optional.of(class_1834.field_8923);
            case 4 -> Optional.of(class_1834.field_8930);
            default -> Optional.of(class_1834.field_22033);
        };
    }

    public static boolean canDiggingClawsHarvest(class_1309 entity, class_2680 state) {
        if (ModItems.DIGGING_CLAWS.get().isEquippedBy(entity)) {
            Optional<class_1832> tier = DiggingClawsItem.getToolTier();
            return tier.isPresent() && PlatformServices.platformHelper.isCorrectTierForDrops(tier.get(), state) && state.method_26164(ModTags.MINEABLE_WITH_DIGGING_CLAWS);
        }
        return false;
    }

    public static float getSpeedBonus(class_1657 player, class_2680 state) {
        if (ModItems.DIGGING_CLAWS.get().isEquippedBy((class_1309)player) && player.method_7305(state)) {
            return ModGameRules.DIGGING_CLAWS_DIG_SPEED_BONUS.get().floatValue();
        }
        return 0.0f;
    }

    @Override
    public class_3414 getEquipSound() {
        return class_3417.field_21866;
    }
}

