/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.minecraft.class_4844;

public class NBTHelper {
    private NBTHelper() {
    }

    public static Optional<Integer> getInt(class_1799 stack, String key) {
        return NBTHelper.getTagValue(stack, key, class_2487::method_10550);
    }

    public static Optional<Integer> getInt(class_2487 tag, String key) {
        return NBTHelper.getTagValue(tag, key, class_2487::method_10550);
    }

    public static Optional<int[]> getIntArray(class_2487 tag, String key) {
        return NBTHelper.getTagValue(tag, key, class_2487::method_10561);
    }

    private static <T> Optional<T> getTagValue(class_1799 stack, String key, BiFunction<class_2487, String, T> getValue) {
        return NBTHelper.getTagValue(stack, "", key, getValue);
    }

    public static <T> Optional<T> getTagValue(class_1799 stack, String parentKey, String key, BiFunction<class_2487, String, T> getValue) {
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return Optional.empty();
        }
        if (!parentKey.isEmpty()) {
            class_2520 parentTag = tag.method_10580(parentKey);
            if (!(parentTag instanceof class_2487)) {
                return Optional.empty();
            }
            tag = (class_2487)parentTag;
        }
        return NBTHelper.getTagValue(tag, key, getValue);
    }

    public static Optional<Boolean> getBoolean(class_2487 tag, String key) {
        return NBTHelper.getTagValue(tag, key, class_2487::method_10577);
    }

    public static Optional<class_2487> getCompound(class_2487 tag, String key) {
        return NBTHelper.getTagValue(tag, key, class_2487::method_10562);
    }

    public static <T> Optional<T> getTagValue(class_2487 tag, String key, BiFunction<class_2487, String, T> getValue) {
        if (!tag.method_10545(key)) {
            return Optional.empty();
        }
        return Optional.of(getValue.apply(tag, key));
    }

    public static boolean hasTag(class_1799 stack, String key) {
        return stack.method_7969() != null && stack.method_7969().method_10545(key);
    }

    public static <E, C extends Collection<E>> Optional<C> getCollection(class_1799 stack, String parentKey, String tagName, byte listType, Function<class_2520, Optional<E>> getElement, Supplier<C> initCollection) {
        return NBTHelper.getTagValue(stack, parentKey, tagName, (c, n) -> c.method_10554(n, (int)listType)).map(listNbt -> {
            Collection ret = (Collection)initCollection.get();
            listNbt.forEach(elementNbt -> ((Optional)getElement.apply((class_2520)elementNbt)).ifPresent(ret::add));
            return ret;
        });
    }

    public static <E, C extends Collection<E>> Optional<C> getCollection(class_2487 tag, String key, byte listType, Function<class_2520, Optional<E>> getElement, Supplier<C> initCollection) {
        return NBTHelper.getTagValue(tag, key, (class_2487 c, String n) -> c.method_10554(n, (int)listType)).map(listNbt -> {
            Collection ret = (Collection)initCollection.get();
            listNbt.forEach(elementNbt -> ((Optional)getElement.apply((class_2520)elementNbt)).ifPresent(ret::add));
            return ret;
        });
    }

    public static Optional<class_2487> getCompound(class_1799 stack, String parentKey, String tagName) {
        return NBTHelper.getTagValue(stack, parentKey, tagName, class_2487::method_10562);
    }

    public static Optional<class_2487> getCompound(class_1799 stack, String tagName) {
        return NBTHelper.getTagValue(stack, tagName, class_2487::method_10562);
    }

    public static <T extends Enum<T>> Optional<T> getEnumConstant(class_1799 stack, String parentKey, String key, Function<String, T> deserialize) {
        return NBTHelper.getTagValue(stack, parentKey, key, (t, k) -> (Enum)deserialize.apply(t.method_10558(k)));
    }

    public static <T extends Enum<T>> Optional<T> getEnumConstant(class_1799 stack, String key, Function<String, T> deserialize) {
        return NBTHelper.getTagValue(stack, key, (class_2487 t, String k) -> (Enum)deserialize.apply(t.method_10558(k)));
    }

    public static <T extends Enum<T>> Optional<T> getEnumConstant(class_2487 tag, String key, Function<String, T> deserialize) {
        return NBTHelper.getTagValue(tag, key, (class_2487 t, String k) -> (Enum)deserialize.apply(t.method_10558(k)));
    }

    public static Optional<Boolean> getBoolean(class_1799 stack, String parentKey, String key) {
        return NBTHelper.getTagValue(stack, parentKey, key, class_2487::method_10577);
    }

    public static Optional<Boolean> getBoolean(class_1799 stack, String key) {
        return NBTHelper.getTagValue(stack, key, class_2487::method_10577);
    }

    public static Optional<Long> getLong(class_1799 stack, String key) {
        return NBTHelper.getTagValue(stack, key, class_2487::method_10537);
    }

    public static Optional<Long> getLong(class_2487 tag, String key) {
        return NBTHelper.getTagValue(tag, key, class_2487::method_10537);
    }

    public static Optional<UUID> getUniqueId(class_1799 stack, String key) {
        return NBTHelper.getTagValue(stack, key, (class_2487 compound, String k) -> class_2512.method_25930((class_2520)compound.method_10580(k)));
    }

    public static void setCompoundNBT(class_1799 stack, String key, class_2487 tag) {
        NBTHelper.setCompoundNBT(stack, "", key, tag);
    }

    public static void setCompoundNBT(class_1799 stack, String parentKey, String key, class_2487 tag) {
        if (parentKey.isEmpty()) {
            stack.method_7948().method_10566(key, (class_2520)tag);
            return;
        }
        stack.method_7911(parentKey).method_10566(key, (class_2520)tag);
    }

    public static void setBoolean(class_1799 stack, String parentKey, String key, boolean value) {
        if (parentKey.isEmpty()) {
            NBTHelper.setBoolean(stack, key, value);
            return;
        }
        NBTHelper.putBoolean(stack.method_7911(parentKey), key, value);
    }

    public static void setBoolean(class_1799 stack, String key, boolean value) {
        NBTHelper.putBoolean(stack.method_7948(), key, value);
    }

    public static <T extends Enum<T>> void setEnumConstant(class_1799 stack, String parentKey, String key, T enumConstant) {
        if (parentKey.isEmpty()) {
            NBTHelper.setEnumConstant(stack, key, enumConstant);
            return;
        }
        NBTHelper.putEnumConstant(stack.method_7911(parentKey), key, enumConstant);
    }

    public static <T extends Enum<T>> void setEnumConstant(class_1799 stack, String key, T enumConstant) {
        NBTHelper.putEnumConstant(stack.method_7948(), key, enumConstant);
    }

    public static class_2487 putBoolean(class_2487 tag, String key, boolean value) {
        tag.method_10556(key, value);
        return tag;
    }

    public static class_2487 putInt(class_2487 tag, String key, int value) {
        tag.method_10569(key, value);
        return tag;
    }

    public static class_2487 putString(class_2487 tag, String key, String value) {
        tag.method_10582(key, value);
        return tag;
    }

    public static <T extends Enum<T>> class_2487 putEnumConstant(class_2487 tag, String key, T enumConstant) {
        tag.method_10582(key, ((class_3542)enumConstant).method_15434());
        return tag;
    }

    public static void setLong(class_1799 stack, String key, long value) {
        stack.method_7948().method_10544(key, value);
    }

    public static void setInteger(class_1799 stack, String key, int value) {
        stack.method_7948().method_10569(key, value);
    }

    public static void setUniqueId(class_1799 stack, String key, UUID uuid) {
        stack.method_7948().method_10539(key, class_4844.method_26275((UUID)uuid));
    }

    public static void removeTag(class_1799 stack, String key) {
        if (stack.method_7969() == null) {
            return;
        }
        stack.method_7969().method_10551(key);
    }

    public static Optional<class_2561> getComponent(class_2487 tag, String key) {
        return NBTHelper.getTagValue(tag, key, (class_2487 t, String k) -> class_2561.class_2562.method_10877((String)t.method_10558(k)));
    }

    public static Optional<String> getString(class_2487 tag, String key) {
        return NBTHelper.getTagValue(tag, key, class_2487::method_10558);
    }

    public static Optional<String> getString(class_1799 stack, String key) {
        return NBTHelper.getTagValue(stack, key, class_2487::method_10558);
    }

    public static Optional<Float> getFloat(class_1799 stack, String key) {
        return NBTHelper.getTagValue(stack, key, class_2487::method_10583);
    }

    public static <K, V> Optional<Map<K, V>> getMap(class_1799 stack, String key, Function<String, K> getKey, BiFunction<String, class_2520, Optional<V>> getValue) {
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return Optional.empty();
        }
        return NBTHelper.getMap(tag, key, getKey, getValue);
    }

    public static <K, V> Optional<Map<K, V>> getMap(class_2487 tag, String key, Function<String, K> getKey, BiFunction<String, class_2520, Optional<V>> getValue) {
        return NBTHelper.getMap(tag, key, getKey, getValue, HashMap::new);
    }

    public static <K, V> Optional<Map<K, V>> getMap(class_2487 tag, String key, Function<String, K> getKey, BiFunction<String, class_2520, Optional<V>> getValue, Supplier<Map<K, V>> initMap) {
        class_2487 mapNbt = tag.method_10562(key);
        Map map = initMap.get();
        for (String tagName : mapNbt.method_10541()) {
            getValue.apply(tagName, mapNbt.method_10580(tagName)).ifPresent(value -> map.put(getKey.apply(tagName), value));
        }
        return Optional.of(map);
    }

    public static <K, V> class_2487 putMap(class_2487 tag, String key, Map<K, V> map, Function<K, String> getStringKey, Function<V, class_2520> getNbtValue) {
        class_2487 mapNbt = new class_2487();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            mapNbt.method_10566(getStringKey.apply(entry.getKey()), getNbtValue.apply(entry.getValue()));
        }
        tag.method_10566(key, (class_2520)mapNbt);
        return tag;
    }

    public static <T> void setList(class_1799 stack, String parentKey, String key, Collection<T> values, Function<T, class_2520> getNbtValue) {
        class_2499 list = new class_2499();
        values.forEach(v -> list.add((Object)((class_2520)getNbtValue.apply(v))));
        if (parentKey.isEmpty()) {
            stack.method_7948().method_10566(key, (class_2520)list);
        } else {
            stack.method_7911(parentKey).method_10566(key, (class_2520)list);
        }
    }

    public static <T> void putList(class_2487 tag, String key, Collection<T> values, Function<T, class_2520> getNbtValue) {
        class_2499 list = new class_2499();
        values.forEach(v -> list.add((Object)((class_2520)getNbtValue.apply(v))));
        tag.method_10566(key, (class_2520)list);
    }
}

