/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity.block_tracking;

import java.util.ArrayList;
import java.util.Objects;
import me.jellysquid.mods.lithium.common.block.BlockListeningSection;
import me.jellysquid.mods.lithium.common.block.ListeningBlockStatePredicate;
import me.jellysquid.mods.lithium.common.util.Pos;
import me.jellysquid.mods.lithium.common.util.deduplication.LithiumInternerWrapper;
import me.jellysquid.mods.lithium.common.util.tuples.WorldSectionBox;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2826;
import net.minecraft.class_4076;
import net.minecraft.class_5539;

public class SectionedBlockChangeTracker {
    public final WorldSectionBox trackedWorldSections;
    public final ListeningBlockStatePredicate blockGroup;
    private long maxChangeTime;
    private int timesRegistered;
    boolean isListeningToAll = false;
    private ArrayList<class_4076> sectionsNotListeningTo = null;
    private ArrayList<BlockListeningSection> sectionsUnsubscribed = null;

    public SectionedBlockChangeTracker(WorldSectionBox trackedWorldSections, ListeningBlockStatePredicate blockGroup) {
        this.trackedWorldSections = trackedWorldSections;
        this.blockGroup = blockGroup;
        this.maxChangeTime = 0L;
    }

    public boolean matchesMovedBox(class_238 box) {
        return this.trackedWorldSections.matchesRelevantBlocksBox(box);
    }

    public static SectionedBlockChangeTracker registerAt(class_1937 world, class_238 entityBoundingBox, ListeningBlockStatePredicate blockGroup) {
        WorldSectionBox worldSectionBox = WorldSectionBox.relevantExpandedBlocksBox(world, entityBoundingBox);
        SectionedBlockChangeTracker tracker = new SectionedBlockChangeTracker(worldSectionBox, blockGroup);
        tracker = ((LithiumInternerWrapper)world).getCanonical(tracker);
        tracker.register();
        return tracker;
    }

    long getWorldTime() {
        return this.trackedWorldSections.world().method_8510();
    }

    public void register() {
        if (this.timesRegistered == 0) {
            WorldSectionBox trackedSections = this.trackedWorldSections;
            for (int x = trackedSections.chunkX1(); x < trackedSections.chunkX2(); ++x) {
                for (int z = trackedSections.chunkZ1(); z < trackedSections.chunkZ2(); ++z) {
                    class_2791 chunk = trackedSections.world().method_8402(x, z, class_2806.field_12803, false);
                    class_2826[] sectionArray = chunk == null ? null : chunk.method_12006();
                    for (int y = trackedSections.chunkY1(); y < trackedSections.chunkY2(); ++y) {
                        if (Pos.SectionYCoord.getMinYSection((class_5539)trackedSections.world()) > y || Pos.SectionYCoord.getMaxYSectionExclusive((class_5539)trackedSections.world()) <= y) continue;
                        if (sectionArray == null) {
                            if (this.sectionsNotListeningTo == null) {
                                this.sectionsNotListeningTo = new ArrayList();
                            }
                            this.sectionsNotListeningTo.add(class_4076.method_18676((int)x, (int)y, (int)z));
                            continue;
                        }
                        class_2826 section = sectionArray[Pos.SectionYIndex.fromSectionCoord((class_5539)trackedSections.world(), y)];
                        BlockListeningSection blockListeningSection = (BlockListeningSection)section;
                        blockListeningSection.addToCallback(this.blockGroup, this);
                    }
                }
            }
            this.setChanged(this.getWorldTime());
        }
        ++this.timesRegistered;
    }

    public void unregister() {
        if (--this.timesRegistered > 0) {
            return;
        }
        WorldSectionBox trackedSections = this.trackedWorldSections;
        class_1937 world = trackedSections.world();
        for (int x = trackedSections.chunkX1(); x < trackedSections.chunkX2(); ++x) {
            for (int z = trackedSections.chunkZ1(); z < trackedSections.chunkZ2(); ++z) {
                class_2791 chunk = world.method_8402(x, z, class_2806.field_12803, false);
                class_2826[] sectionArray = chunk == null ? null : chunk.method_12006();
                for (int y = trackedSections.chunkY1(); y < trackedSections.chunkY2(); ++y) {
                    if (sectionArray == null || Pos.SectionYCoord.getMinYSection((class_5539)world) > y || Pos.SectionYCoord.getMaxYSectionExclusive((class_5539)world) <= y) continue;
                    class_2826 section = sectionArray[Pos.SectionYIndex.fromSectionCoord((class_5539)world, y)];
                    BlockListeningSection blockListeningSection = (BlockListeningSection)section;
                    blockListeningSection.removeFromCallback(this.blockGroup, this);
                }
            }
        }
        this.sectionsNotListeningTo = null;
        ((LithiumInternerWrapper)world).deleteCanonical(this);
    }

    public void listenToAllSections() {
        boolean changed = false;
        ArrayList<class_4076> notListeningTo = this.sectionsNotListeningTo;
        if (notListeningTo != null) {
            for (int i = notListeningTo.size() - 1; i >= 0; --i) {
                changed = true;
                class_4076 chunkSectionPos = notListeningTo.get(i);
                class_2791 chunk = this.trackedWorldSections.world().method_8402(chunkSectionPos.method_10263(), chunkSectionPos.method_10260(), class_2806.field_12803, false);
                if (chunk == null) {
                    return;
                }
                notListeningTo.remove(i);
                class_2826 section = chunk.method_12006()[Pos.SectionYIndex.fromSectionCoord((class_5539)this.trackedWorldSections.world(), chunkSectionPos.method_10264())];
                BlockListeningSection blockListeningSection = (BlockListeningSection)section;
                blockListeningSection.addToCallback(this.blockGroup, this);
            }
        }
        if (this.sectionsUnsubscribed != null) {
            ArrayList<BlockListeningSection> unsubscribed = this.sectionsUnsubscribed;
            for (int i = unsubscribed.size() - 1; i >= 0; --i) {
                changed = true;
                BlockListeningSection blockListeningSection = unsubscribed.remove(i);
                blockListeningSection.addToCallback(this.blockGroup, this);
            }
        }
        this.isListeningToAll = true;
        if (changed) {
            this.setChanged(this.getWorldTime());
        }
    }

    public void setChanged(BlockListeningSection section) {
        if (this.sectionsUnsubscribed == null) {
            this.sectionsUnsubscribed = new ArrayList();
        }
        this.sectionsUnsubscribed.add(section);
        this.setChanged(this.getWorldTime());
        this.isListeningToAll = false;
    }

    public void setChanged(long atTime) {
        if (atTime > this.maxChangeTime) {
            this.maxChangeTime = atTime;
        }
    }

    public boolean isUnchangedSince(long lastCheckedTime) {
        if (lastCheckedTime <= this.maxChangeTime) {
            return false;
        }
        if (!this.isListeningToAll) {
            this.listenToAllSections();
            return this.isListeningToAll && lastCheckedTime > this.maxChangeTime;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SectionedBlockChangeTracker that = (SectionedBlockChangeTracker)obj;
        return Objects.equals(this.trackedWorldSections, that.trackedWorldSections) && Objects.equals(this.blockGroup, that.blockGroup);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.trackedWorldSections.hashCode() ^ this.blockGroup.hashCode();
    }
}

