/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.cosmetics;

import com.google.gson.JsonObject;
import dev.mayaqq.estrogen.client.cosmetics.CosmeticAnimation;
import dev.mayaqq.estrogen.client.cosmetics.CosmeticModel;
import dev.mayaqq.estrogen.client.cosmetics.CosmeticTexture;
import dev.mayaqq.estrogen.client.cosmetics.model.animation.AnimationDefinition;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public record Cosmetic(String id, String name, CosmeticTexture texture, CosmeticModel model, Optional<CosmeticAnimation> animation) {
    public static Cosmetic fromJson(String id, JsonObject json) {
        String name = class_3518.method_15253((JsonObject)json, (String)"name", (String)id);
        CosmeticTexture texture = new CosmeticTexture(json.get("texture").getAsString());
        CosmeticModel model = new CosmeticModel(json.get("model").getAsString());
        Optional<CosmeticAnimation> animation = json.has("animation") ? Optional.of(new CosmeticAnimation(json.get("animation").getAsString())) : Optional.empty();
        return new Cosmetic(id, name, texture, model, animation);
    }

    public void render(Function<class_2960, class_1921> renderType, class_4597 source, class_4587 matrices, int light, int overlay) {
        this.model.get().ifPresent(model -> {
            this.animation.flatMap(CosmeticAnimation::getResult).ifPresent(model::runAnimation);
            model.getMesh().renderInto(source.getBuffer((class_1921)renderType.apply(this.texture.getResourceLocation())), matrices, -1, light, overlay);
        });
    }

    public boolean useDefaultAnimation() {
        return this.animation.flatMap(CosmeticAnimation::getResult).map(AnimationDefinition::defaultAnimation).orElse(true);
    }
}

