/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.cosmetics.ui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import dev.mayaqq.estrogen.client.cosmetics.Cosmetic;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5603;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CosmeticIconWidget
extends AbstractSimiWidget {
    public static final class_5603 DEFAULT_POSE = class_5603.method_32092((float)30.0f, (float)225.0f, (float)0.0f);
    private static final Vector3f LIGHT_0 = new Vector3f(0.2f, -1.0f, -0.5f).normalize();
    private static final Vector3f LIGHT_1 = new Vector3f(-0.8f, -1.0f, 1.0f).normalize();
    private class_5603 pose;
    private Cosmetic cosmetic;
    private ContentScaling contentScalingMode = ContentScaling.NONE;
    private HighlightPredicate hoverPredicate;
    private float scale = 0.5f;
    private float rotationSpeed;
    private boolean overrideAnimationSetting = false;
    private final LerpedFloat overlayAnimation = LerpedFloat.linear();
    private boolean isHovered;
    private float animRot;
    public boolean debug;

    public CosmeticIconWidget(Cosmetic cosmetic, int x, int y, int width, int height, @Nullable class_5603 referencePose) {
        super(x, y, width, height);
        this.cosmetic = cosmetic;
        this.pose = referencePose != null ? referencePose : DEFAULT_POSE;
        this.z = 150.0f;
        this.defaultHighlightPredicate();
    }

    public static CosmeticIconWidget of(Cosmetic cosmetic) {
        return new CosmeticIconWidget(cosmetic, 0, 0, 0, 0, null);
    }

    protected void beforeRender(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.beforeRender(graphics, mouseX, mouseY, partialTicks);
        if (!this.field_22764) {
            return;
        }
        boolean hover = this.hoverPredicate.test(this, mouseX, mouseY);
        if (hover != this.isHovered) {
            this.isHovered = hover;
            this.overlayAnimation.startWithValue(hover ? 0.0 : 1.0);
            this.overlayAnimation.chase(hover ? 1.0 : 0.0, 0.6, LerpedFloat.Chaser.EXP);
            this.overlayAnimation.tickChaser();
        }
    }

    protected void doRender(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        class_4587 matrices = graphics.method_51448();
        matrices.method_46416((float)this.method_46426(), (float)(this.method_46427() + 16), this.z);
        Vector3fc modelSize = this.cosmetic.model().getModelSize();
        Vector2f modelScale = this.contentScalingMode.calculate(this.field_22758, this.field_22759, modelSize);
        matrices.method_46416(0.0f, (float)this.field_22759 - modelSize.y(), 0.0f);
        matrices.method_22905(16.0f * modelScale.x, -16.0f * modelScale.y, 16.0f * modelScale.x);
        if (this.pose.field_27702 != 0.0f || this.pose.field_27703 != 0.0f || this.pose.field_27704 != 0.0f) {
            matrices.method_46416(this.pose.field_27702 / 16.0f, this.pose.field_27703 / 16.0f, this.pose.field_27704 / 16.0f);
        }
        if (this.rotateOrScale()) {
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_22905(this.scale, this.scale, this.scale);
            matrices.method_22907(this.rotateXYZ(this.pose.field_27705, this.pose.field_27706, this.pose.field_27707));
            if (this.rotationSpeed != 0.0f && (this.overrideAnimationSetting || this.cosmetic.useDefaultAnimation())) {
                matrices.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_16439((float)partialTicks, (float)this.animRot, (float)(this.animRot + this.rotationSpeed))));
            }
            matrices.method_46416(-0.5f, -0.5f, -0.5f);
        }
        if (this.debug) {
            this.drawDebugBounds(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -1);
            this.drawDebugBounds(this.method_46426(), this.method_46427(), (float)this.method_46426() + modelSize.x(), (float)this.method_46427() + modelSize.y(), -65536);
        }
        float animation = this.overlayAnimation.getValue(partialTicks);
        int overlay = this.isHovered || !this.overlayAnimation.settled() ? class_4608.method_23624((float)(animation * 0.5f), (boolean)false) : class_4608.field_21444;
        RenderSystem.setShaderLights((Vector3f)LIGHT_0, (Vector3f)LIGHT_1);
        this.cosmetic.render(class_1921::method_23576, (class_4597)graphics.method_51450(), matrices, 0xF000F0, overlay);
        graphics.method_51452();
    }

    private void drawDebugBounds(float minX, float minY, float maxX, float maxY, int color) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        builder.method_22912((double)minX, (double)minY, 0.0).method_39415(color).method_1344();
        builder.method_22912((double)minX, (double)maxY, 0.0).method_39415(color).method_1344();
        builder.method_22912((double)maxX, (double)maxY, 0.0).method_39415(color).method_1344();
        builder.method_22912((double)maxX, (double)minY, 0.0).method_39415(color).method_1344();
        class_289.method_1348().method_1350();
        RenderSystem.disableBlend();
    }

    public void tick() {
        if (this.rotationSpeed > 0.0f && (this.overrideAnimationSetting || this.cosmetic.useDefaultAnimation())) {
            this.animRot += this.rotationSpeed;
            if (this.animRot >= 360.0f) {
                this.animRot = 0.0f;
            }
        }
        this.overlayAnimation.tickChaser();
    }

    public CosmeticIconWidget overrideAnimationSetting() {
        this.overrideAnimationSetting = true;
        return this;
    }

    public CosmeticIconWidget withRotationSpeed(float speed) {
        this.rotationSpeed = speed;
        return this;
    }

    public CosmeticIconWidget withScale(float scale) {
        this.scale = scale;
        return this;
    }

    public CosmeticIconWidget withSize(int width, int height) {
        this.field_22758 = width;
        this.field_22759 = height;
        return this;
    }

    public CosmeticIconWidget withContentScaling(ContentScaling mode) {
        this.contentScalingMode = mode;
        return this;
    }

    public CosmeticIconWidget withPose(class_5603 pose) {
        this.pose = pose;
        return this;
    }

    public CosmeticIconWidget withHighlightPredicate(HighlightPredicate predicate) {
        this.hoverPredicate = predicate;
        return this;
    }

    public CosmeticIconWidget defaultHighlightPredicate() {
        this.hoverPredicate = HighlightPredicate.DEFAULT;
        return this;
    }

    public CosmeticIconWidget neverHighlight() {
        return this.withHighlightPredicate(($0, $1, $2) -> false);
    }

    public CosmeticIconWidget withDefaultPose() {
        this.pose = DEFAULT_POSE;
        return this;
    }

    public CosmeticIconWidget debug() {
        this.debug = true;
        return this;
    }

    public boolean rotateOrScale() {
        return this.pose.field_27705 != 0.0f || this.pose.field_27706 != 0.0f || this.pose.field_27707 != 0.0f || this.scale != 1.0f || this.rotationSpeed != 0.0f || this.animRot != 0.0f;
    }

    public void setCosmetic(Cosmetic cosmetic) {
        this.cosmetic = cosmetic;
    }

    private Quaternionf rotateXYZ(float x, float y, float z) {
        return new Quaternionf().rotateXYZ(x * ((float)Math.PI / 180), y * ((float)Math.PI / 180), z * ((float)Math.PI / 180));
    }

    private void applyContentScaling() {
    }

    @FunctionalInterface
    public static interface ContentScaling {
        public static final ContentScaling NONE = (width, height, modelSize) -> new Vector2f(1.0f, 1.0f);
        public static final ContentScaling SCALE_X = (width, height, modelSize) -> new Vector2f(width / modelSize.x(), width / modelSize.x());
        public static final ContentScaling SCALE_Y = (width, height, modelSize) -> new Vector2f(height / modelSize.y(), height / modelSize.y());
        public static final ContentScaling AUTO = (width, height, modelSize) -> modelSize.x() > modelSize.y() ? SCALE_Y.calculate(width, height, modelSize) : SCALE_X.calculate(width, height, modelSize);
        public static final ContentScaling SQUISH = (width, height, modelSize) -> new Vector2f(width / modelSize.x(), height / modelSize.y());

        public Vector2f calculate(float var1, float var2, Vector3fc var3);
    }

    @FunctionalInterface
    public static interface HighlightPredicate {
        public static final HighlightPredicate DEFAULT = (self, mouseX, mouseY) -> mouseX >= self.method_46426() && mouseX <= self.method_46426() + self.field_22758 && mouseY >= self.method_46427() && mouseY <= self.method_46427() + self.field_22759;

        public boolean test(CosmeticIconWidget var1, int var2, int var3);
    }
}

