/*
 * Decompiled with CFR 0.152.
 */
package com.cak.trading_floor.fabric.content.depot;

import com.cak.trading_floor.content.trading_depot.CommonTradingDepotBlockEntity;
import com.cak.trading_floor.content.trading_depot.behavior.CommonTradingDepotBehaviorAccess;
import com.cak.trading_floor.fabric.content.depot.TradingDepotBlock;
import com.cak.trading_floor.fabric.content.depot.behavior.TradingDepotBehaviour;
import com.cak.trading_floor.fabric.content.depot.behavior.TradingDepotValueBox;
import com.cak.trading_floor.foundation.AttachedTradingDepotFinder;
import com.cak.trading_floor.foundation.MerchantOfferInfo;
import com.cak.trading_floor.foundation.TFLang;
import com.cak.trading_floor.foundation.advancement.TFAdvancementBehaviour;
import com.cak.trading_floor.foundation.advancement.TFAdvancements;
import com.cak.trading_floor.registry.TFParticleEmitters;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.LangBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_124;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class TradingDepotBlockEntity
extends CommonTradingDepotBlockEntity
implements SidedStorageBlockEntity {
    TradingDepotBehaviour tradingDepotBehaviour;
    FilteringBehaviour filtering;
    List<class_2586> tradingDepotsForDisplay = new ArrayList<class_2586>();
    @Nullable
    MerchantOfferInfo lastTrade;
    int lastTradeCount = 0;
    int tradeOutputSum = 0;
    int currentTradeCompletedCount = 0;
    int emeraldsProduced = 0;

    public TradingDepotBlockEntity(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        int tradingDepotOtherSourceCount;
        class_2338 attachedWorkstationPosition = this.method_11016().method_10093(((class_2350)this.method_11010().method_11654((class_2769)TradingDepotBlock.field_11177)).method_10153());
        this.updateOtherSourcesForTooltip(attachedWorkstationPosition);
        this.tradingDepotBehaviour.addContentsToTooltip(tooltip);
        if (this.lastTrade != null) {
            TFLang.translate("tooltip.trading_depot.last_trade", new Object[0]).add(TFLang.text(" (x" + this.lastTradeCount + ")").color(this.lastTradeCount == 0 ? 0xFF5555 : 0x55FFFF)).forGoggles(tooltip);
            this.addTradeToGoggles(tooltip, this.lastTrade);
        }
        if ((tradingDepotOtherSourceCount = this.tradingDepotsForDisplay.size() - 1) > 0) {
            TFLang.text("").forGoggles(tooltip);
            TFLang.translate("tooltip.trading_depot.connected_to_other", new Object[0]).add(TFLang.text(" " + tradingDepotOtherSourceCount + " ").style(class_124.field_1075)).translate("tooltip.trading_depot.other_trading_depot" + (tradingDepotOtherSourceCount > 1 ? "s" : ""), new Object[0]).style(class_124.field_1063).forGoggles(tooltip);
        }
        return true;
    }

    private void addTradeToGoggles(List<class_2561> tooltip, MerchantOfferInfo trade) {
        LangBuilder costText = TFLang.itemStack(trade.getCostA());
        if (!trade.getCostB().method_7960()) {
            costText.text(" + ").add(TFLang.itemStack(trade.getCostB())).style(class_124.field_1080);
        }
        costText.forGoggles(tooltip, 1);
        TFLang.text("\u2192 ").add(TFLang.itemStack(trade.getResult())).style(class_124.field_1068).forGoggles(tooltip, 2);
    }

    private void updateOtherSourcesForTooltip(class_2338 attachedWorkstationPosition) {
        if (this.field_11863 == null) {
            this.tradingDepotsForDisplay = new ArrayList<class_2586>();
            return;
        }
        this.tradingDepotsForDisplay = AttachedTradingDepotFinder.lookForTradingDepots((class_1936)this.field_11863, attachedWorkstationPosition).stream().map(blockPos -> this.field_11863.method_8321(blockPos)).filter(blockEntity -> blockEntity instanceof TradingDepotBlockEntity).toList();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tradingDepotBehaviour = new TradingDepotBehaviour(this);
        behaviours.add(this.tradingDepotBehaviour);
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new TradingDepotValueBox()).withCallback($ -> this.tradingDepotBehaviour.resetInv());
        behaviours.add((BlockEntityBehaviour)this.filtering);
        this.filtering.setLabel(TFLang.translate("tooltip.trading_depot.filtering.trade_filter", new Object[0]).component());
        TFAdvancementBehaviour.create(behaviours, this, TFAdvancements.MONEY_MONEY_MONEY, TFAdvancements.BUDDING_CAPITALIST, TFAdvancements.HAPPY_JEFF);
        this.tradingDepotBehaviour.filtering = this.filtering;
        this.tradingDepotBehaviour.addAdditionalBehaviours(behaviours);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.tradingDepotBehaviour.invalidate();
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (tag.method_10545("LastTrade")) {
            this.lastTrade = MerchantOfferInfo.read(tag.method_10562("LastTrade"));
        }
        this.lastTradeCount = tag.method_10550("LastTradeCount");
        this.emeraldsProduced = tag.method_10550("EmeraldsProduced");
        this.tradeOutputSum = tag.method_10550("TradeOutputSum");
        this.currentTradeCompletedCount = tag.method_10550("CurrentTradeCompletedCount");
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.lastTrade != null) {
            tag.method_10566("LastTrade", this.lastTrade.write(new class_2487()));
        }
        tag.method_10569("LastTradeCount", this.lastTradeCount);
        if (((TFAdvancementBehaviour)this.getBehaviour(TFAdvancementBehaviour.TYPE)).isOwnerPresent()) {
            tag.method_10569("EmeraldsProduced", this.emeraldsProduced);
        }
        tag.method_10569("TradeOutputSum", this.tradeOutputSum);
        tag.method_10569("CurrentTradeCompletedCount", this.currentTradeCompletedCount);
    }

    protected boolean tryTakeMerchantOffer(class_1914 offer, TradingDepotBehaviour costASource, List<TradingDepotBehaviour> costBSources) {
        if (!class_1799.method_7984((class_1799)offer.method_8246(), (class_1799)costASource.getOfferStack())) {
            return false;
        }
        class_1799 totalCostBSource = class_1799.field_8037;
        if (!offer.method_8247().method_7960()) {
            if ((costBSources = costBSources.stream().filter(depot -> class_1799.method_7984((class_1799)offer.method_8247(), (class_1799)depot.getOfferStack())).toList()).isEmpty()) {
                return false;
            }
            int totalCostB = 0;
            for (TradingDepotBehaviour depot2 : costBSources) {
                totalCostB += depot2.getOfferStack().method_7947();
            }
            if (offer.method_8247().method_7947() > totalCostB) {
                return false;
            }
            totalCostBSource = costBSources.get(0).getOfferStack().method_46651(totalCostB);
        }
        if (!TradingDepotBlockEntity.satisfiedBaseCostBy(offer, costASource.getOfferStack(), totalCostBSource)) {
            return false;
        }
        costASource.setOfferStack(costASource.getOfferStack().method_46651(costASource.getOfferStack().method_7947() - offer.method_8246().method_7947()));
        this.takeTotalFromSources(costBSources, offer.method_8247().method_7947());
        costASource.getResults().add(offer.method_18019());
        return true;
    }

    protected void takeTotalFromSources(List<TradingDepotBehaviour> costBSources, int totalExtractCount) {
        int i = 0;
        while (totalExtractCount > 0) {
            if (costBSources.size() <= i) {
                return;
            }
            TradingDepotBehaviour costSource = costBSources.get(i);
            int currentCount = costSource.getOfferStack().method_7947();
            int extractCount = Math.min(totalExtractCount, currentCount);
            costSource.setOfferStack(costSource.getOfferStack().method_46651(currentCount - extractCount));
            totalExtractCount -= extractCount;
            ++i;
        }
    }

    @Override
    public void tryTradeWith(class_1646 villager, List<CommonTradingDepotBehaviorAccess> allDepots) {
        if (!this.tradingDepotBehaviour.isOutputEmpty()) {
            return;
        }
        List<TradingDepotBehaviour> allForgeDepots = allDepots.stream().map(depot -> (TradingDepotBehaviour)depot).toList();
        List<TradingDepotBehaviour> costBSources = allForgeDepots.stream().filter(depot -> depot != this.tradingDepotBehaviour).toList();
        boolean hadSuccessfulTrade = false;
        boolean hasSpace = true;
        MerchantOfferInfo latestTrade = null;
        int latestTradeCount = 0;
        for (class_1914 offer : villager.method_8264()) {
            if (!hasSpace) break;
            if (!this.filtering.test(offer.method_8250())) continue;
            List<TradingDepotBehaviour> filteredCostBSources = costBSources.stream().filter(depot -> depot.canBeUsedFor(offer)).toList();
            boolean trading = true;
            while (trading) {
                if (this.tradingDepotBehaviour.getResults().size() >= 8) {
                    this.tradingDepotBehaviour.combineOutputs();
                    if (this.tradingDepotBehaviour.getResults().size() >= 8) {
                        hasSpace = false;
                        break;
                    }
                }
                if (trading = this.tryTakeMerchantOffer(offer, this.tradingDepotBehaviour, filteredCostBSources)) {
                    latestTrade = new MerchantOfferInfo(offer);
                    ++latestTradeCount;
                }
                hadSuccessfulTrade = hadSuccessfulTrade || trading;
            }
            if (!hadSuccessfulTrade) continue;
            break;
        }
        if (hadSuccessfulTrade) {
            this.tradingDepotBehaviour.combineOutputs();
            villager.method_20010();
            ((TFAdvancementBehaviour)this.getBehaviour(TFAdvancementBehaviour.TYPE)).awardPlayer(TFAdvancements.MONEY_MONEY_MONEY);
            class_1937 class_19372 = this.field_11863;
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                TFParticleEmitters.TRADE_COMPLETED.emitToClients(serverLevel, class_243.method_24953((class_2382)this.method_11016()).method_1031(0.0, 0.4, 0.0), 4);
            }
        }
        if (latestTrade != null && !Objects.equals(this.lastTrade, latestTrade)) {
            this.currentTradeCompletedCount = 0;
            this.tradeOutputSum = 0;
        }
        this.lastTrade = latestTrade;
        if (latestTrade != null) {
            this.currentTradeCompletedCount += latestTradeCount;
            this.tradeOutputSum += latestTradeCount * latestTrade.getResult().method_7947();
            this.lastTradeCount = latestTradeCount;
        }
        this.checkForAwardedAdvancements();
        this.notifyUpdate();
    }

    private void checkForAwardedAdvancements() {
        if (this.lastTrade != null && this.lastTrade.getResult().method_31574(class_1802.field_8687)) {
            TFAdvancementBehaviour advancementBehaviour = (TFAdvancementBehaviour)this.getBehaviour(TFAdvancementBehaviour.TYPE);
            if (this.tradeOutputSum >= 64) {
                advancementBehaviour.awardPlayer(TFAdvancements.BUDDING_CAPITALIST);
            }
            if (this.tradeOutputSum >= 1000) {
                advancementBehaviour.awardPlayer(TFAdvancements.HAPPY_JEFF);
            }
        }
    }

    public static boolean satisfiedBaseCostBy(class_1914 offer, class_1799 playerOfferA, class_1799 playerOfferB) {
        return TradingDepotBlockEntity.isRequiredItem(playerOfferA, offer.method_8246()) && playerOfferA.method_7947() >= offer.method_8246().method_7947() && TradingDepotBlockEntity.isRequiredItem(playerOfferB, offer.method_8247()) && playerOfferB.method_7947() >= offer.method_8247().method_7947();
    }

    private static boolean isRequiredItem(class_1799 available, class_1799 cost) {
        if (cost.method_7960() && available.method_7960()) {
            return true;
        }
        class_1799 itemstack = available.method_7972();
        return class_1799.method_7984((class_1799)itemstack, (class_1799)cost) && (!cost.method_7985() || itemstack.method_7985() && class_2512.method_10687((class_2520)cost.method_7969(), (class_2520)itemstack.method_7969(), (boolean)false));
    }

    @Override
    public boolean hasInputStack() {
        return this.tradingDepotBehaviour.getOffer() != null && !this.tradingDepotBehaviour.getOfferStack().method_7960();
    }

    @Override
    public int getCurrentTradeCompletedCount() {
        return this.currentTradeCompletedCount;
    }

    @Override
    public int getTradeOutputSum() {
        return this.tradeOutputSum;
    }

    @Override
    @Nullable
    public MerchantOfferInfo getLastTrade() {
        return this.lastTrade;
    }

    @Override
    public CommonTradingDepotBehaviorAccess getCommonTradingDepotBehaviour() {
        return this.tradingDepotBehaviour;
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 side) {
        return this.tradingDepotBehaviour.getRealItemHandler();
    }
}

