/*
 * Decompiled with CFR 0.152.
 */
package com.cak.trading_floor.fabric.content.depot;

import com.cak.trading_floor.fabric.content.depot.behavior.TradingDepotBehaviour;
import java.util.ArrayList;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;

public class TradingDepotItemHandler
implements Storage<ItemVariant> {
    TradingDepotBehaviour behaviour;

    public TradingDepotItemHandler(TradingDepotBehaviour behaviour) {
        this.behaviour = behaviour;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        class_1799 currentStack = this.behaviour.getOfferStack();
        if (!resource.matches(currentStack) && !currentStack.method_7960()) {
            return 0L;
        }
        int oldCount = currentStack.method_7947();
        int resultCount = (int)Math.min((long)currentStack.method_7947() + maxAmount, (long)currentStack.method_7914());
        int stackChange = resultCount - currentStack.method_7947();
        class_1799 resultStack = resource.toStack(resultCount);
        transaction.addCloseCallback((context, result) -> {
            if (result.wasCommitted()) {
                this.behaviour.setOfferStack(resultStack);
                if (resultCount != oldCount) {
                    this.behaviour.spinOfferOrSomething();
                }
                this.behaviour.blockEntity.sendData();
            }
        });
        return stackChange;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        int targetIndex = -1;
        for (int i = 0; i < this.behaviour.getResults().size(); ++i) {
            if (resource.matches(this.behaviour.getResults().get(i))) {
                targetIndex = i;
            }
            if (targetIndex != -1) break;
        }
        if (targetIndex == -1) {
            return 0L;
        }
        class_1799 currentStack = this.behaviour.getResults().get(targetIndex);
        int extractedCount = (int)Math.min((long)currentStack.method_7947(), maxAmount);
        class_1799 remainderStack = currentStack.method_46651(currentStack.method_7947() - extractedCount);
        int finalTargetIndex = targetIndex;
        transaction.addCloseCallback((context, result) -> {
            if (result.wasCommitted()) {
                this.behaviour.getResults().set(finalTargetIndex, remainderStack);
                this.behaviour.queueResultStackPrune();
                this.behaviour.blockEntity.sendData();
            }
        });
        return extractedCount;
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        ArrayList<Object> combined = new ArrayList<Object>();
        for (int i = 0; i < this.behaviour.getResults().size(); ++i) {
            combined.add(new ResultsStorageView(i));
        }
        combined.add(new OfferStorageView());
        return combined.iterator();
    }

    private class ResultsStorageView
    implements StorageView<ItemVariant> {
        int pos;

        public ResultsStorageView(int pos) {
            this.pos = pos;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transactionContext) {
            if (TradingDepotItemHandler.this.behaviour.getResults().size() - 1 < this.pos) {
                return 0L;
            }
            class_1799 current = TradingDepotItemHandler.this.behaviour.getResults().get(this.pos);
            if (current.method_7960()) {
                return 0L;
            }
            if (!resource.matches(current)) {
                return 0L;
            }
            int extracted = (int)Math.min((long)current.method_7947(), maxAmount);
            transactionContext.addCloseCallback((transaction, result) -> {
                if (result.wasAborted()) {
                    return;
                }
                int newCurrentCount = current.method_7947() - extracted;
                class_1799 newCurrent = current.method_46651(newCurrentCount);
                TradingDepotItemHandler.this.behaviour.getResults().set(this.pos, newCurrent);
                TradingDepotItemHandler.this.behaviour.queueResultStackPrune();
                TradingDepotItemHandler.this.behaviour.blockEntity.sendData();
            });
            return extracted;
        }

        public boolean isResourceBlank() {
            return this.getStackSafe().method_7960();
        }

        public ItemVariant getResource() {
            return ItemVariant.of((class_1799)this.getStackSafe());
        }

        private class_1799 getStackSafe() {
            return TradingDepotItemHandler.this.behaviour.getResults().size() - 1 < this.pos ? class_1799.field_8037 : TradingDepotItemHandler.this.behaviour.getResults().get(this.pos);
        }

        public long getAmount() {
            return this.getStackSafe().method_7960() ? 0L : (long)this.getStackSafe().method_7947();
        }

        public long getCapacity() {
            return this.getStackSafe().method_7960() ? 64L : (long)this.getStackSafe().method_7914();
        }
    }

    private class OfferStorageView
    implements StorageView<ItemVariant> {
        private OfferStorageView() {
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        public boolean isResourceBlank() {
            return TradingDepotItemHandler.this.behaviour.getOfferStack().method_7960();
        }

        public ItemVariant getResource() {
            return ItemVariant.of((class_1799)TradingDepotItemHandler.this.behaviour.getOfferStack());
        }

        public long getAmount() {
            return TradingDepotItemHandler.this.behaviour.getOfferStack().method_7960() ? 0L : (long)TradingDepotItemHandler.this.behaviour.getOfferStack().method_7947();
        }

        public long getCapacity() {
            return TradingDepotItemHandler.this.behaviour.getOfferStack().method_7960() ? 64L : (long)TradingDepotItemHandler.this.behaviour.getOfferStack().method_7914();
        }
    }
}

