/*
 * Decompiled with CFR 0.152.
 */
package com.cak.trading_floor.fabric.content.depot.behavior;

import com.cak.trading_floor.content.trading_depot.behavior.CommonTradingDepotBehaviorAccess;
import com.cak.trading_floor.fabric.content.depot.TradingDepotItemHandler;
import com.cak.trading_floor.foundation.TFLang;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public class TradingDepotBehaviour
extends BlockEntityBehaviour
implements CommonTradingDepotBehaviorAccess {
    public static final BehaviourType<TradingDepotBehaviour> TYPE = new BehaviourType();
    public FilteringBehaviour filtering;
    final TradingDepotItemHandler itemHandler = new TradingDepotItemHandler(this);
    final LazyOptional<TradingDepotItemHandler> itemHandlerLazyOptional = LazyOptional.of(() -> this.itemHandler);
    @Nullable
    TransportedItemStack offer = null;
    List<class_1799> result = new ArrayList<class_1799>();
    List<TransportedItemStack> incoming = new ArrayList<TransportedItemStack>();
    VersionedInventoryTrackerBehaviour invVersionTracker;
    boolean pruneResultStackNextTick;

    public TradingDepotBehaviour(SmartBlockEntity be) {
        super(be);
    }

    public void tick() {
        super.tick();
        class_1937 world = this.blockEntity.method_10997();
        if (world == null) {
            return;
        }
        if (this.pruneResultStackNextTick) {
            this.result = new ArrayList<class_1799>(this.result.stream().filter(stack -> !stack.method_7960()).toList());
            this.pruneResultStackNextTick = false;
        }
        Iterator<TransportedItemStack> iterator = this.incoming.iterator();
        while (iterator.hasNext()) {
            TransportedItemStack ts = iterator.next();
            if (!this.tick(ts) || world.field_9236 && !this.blockEntity.isVirtual()) continue;
            if (this.offer == null) {
                this.offer = ts;
            } else if (!ItemHelper.canItemStackAmountsStack((class_1799)this.offer.stack, (class_1799)ts.stack)) {
                class_243 vec = VecHelper.getCenterOf((class_2382)this.blockEntity.method_11016());
                class_1264.method_5449((class_1937)this.blockEntity.method_10997(), (double)vec.field_1352, (double)(vec.field_1351 + 0.5), (double)vec.field_1350, (class_1799)ts.stack);
            } else {
                this.offer.stack.method_7933(ts.stack.method_7947());
            }
            iterator.remove();
            this.blockEntity.notifyUpdate();
        }
        if (this.offer == null) {
            return;
        }
        this.tick(this.offer);
    }

    protected boolean tick(TransportedItemStack input) {
        input.prevBeltPosition = input.beltPosition;
        input.prevSideOffset = input.sideOffset;
        float diff = 0.5f - input.beltPosition;
        if (diff > 0.001953125f) {
            if (diff > 0.03125f && !BeltHelper.isItemUpright((class_1799)input.stack)) {
                ++input.angle;
            }
            input.beltPosition += diff / 4.0f;
        }
        return diff < 0.0625f;
    }

    public void addAdditionalBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour(this.blockEntity).allowingBeltFunnels().setInsertionHandler(this::tryInsertingFromSide));
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour(this.blockEntity);
        behaviours.add((BlockEntityBehaviour)this.invVersionTracker);
    }

    private class_1799 tryInsertingFromSide(TransportedItemStack transportedStack, class_2350 side, boolean simulate) {
        class_1799 inserted = transportedStack.stack;
        int size = transportedStack.stack.method_7947();
        transportedStack = transportedStack.copy();
        transportedStack.beltPosition = side.method_10166().method_10178() ? 0.5f : 0.0f;
        transportedStack.insertedFrom = side;
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        class_1799 remainder = this.insert(transportedStack, simulate);
        if (remainder.method_7947() != size) {
            this.blockEntity.notifyUpdate();
        }
        return remainder;
    }

    public int getPresentStackSize() {
        int cumulativeStackSize = 0;
        cumulativeStackSize += this.getOfferStack().method_7947();
        for (class_1799 stack : this.result) {
            cumulativeStackSize += stack.method_7947();
        }
        return cumulativeStackSize;
    }

    public int getRemainingSpace() {
        int cumulativeStackSize = this.getPresentStackSize();
        for (TransportedItemStack transportedItemStack : this.incoming) {
            cumulativeStackSize += transportedItemStack.stack.method_7947();
        }
        return 64 - cumulativeStackSize;
    }

    public class_1799 insert(TransportedItemStack input, boolean simulate) {
        int remainingSpace = this.getRemainingSpace();
        class_1799 inserted = input.stack;
        if (remainingSpace <= 0) {
            return inserted;
        }
        if (this.offer != null && !this.offer.stack.method_7960() && !ItemHandlerHelper.canItemStacksStack((class_1799)this.offer.stack, (class_1799)inserted)) {
            return inserted;
        }
        class_1799 returned = class_1799.field_8037;
        if (remainingSpace < inserted.method_7947()) {
            returned = ItemHandlerHelper.copyStackWithSize((class_1799)input.stack, (int)(inserted.method_7947() - remainingSpace));
            if (!simulate) {
                TransportedItemStack copy = input.copy();
                copy.stack.method_7939(remainingSpace);
                if (this.offer != null && !this.offer.stack.method_7960()) {
                    this.incoming.add(copy);
                } else {
                    this.offer = copy;
                }
            }
        } else if (!simulate) {
            if (this.offer != null && !this.offer.stack.method_7960()) {
                this.incoming.add(input);
            } else {
                this.offer = input;
            }
        }
        return returned;
    }

    public boolean isEmpty() {
        return this.offer == null && this.isOutputEmpty();
    }

    public boolean isOutputEmpty() {
        for (class_1799 stack : this.result) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public void destroy() {
        super.destroy();
        class_1937 level = this.getWorld();
        class_2338 pos = this.getPos();
        ItemHelper.dropContents((class_1937)level, (class_2338)pos, (Storage)this.itemHandler);
    }

    public void unload() {
        if (this.itemHandlerLazyOptional != null) {
            this.itemHandlerLazyOptional.invalidate();
        }
    }

    public void read(class_2487 nbt, boolean clientPacket) {
        this.offer = null;
        if (nbt.method_10545("Input")) {
            this.offer = TransportedItemStack.read((class_2487)nbt.method_10562("Input"));
        }
        int outputCount = nbt.method_10550("OutputCount");
        this.result = new ArrayList<class_1799>(outputCount);
        for (int i = 0; i < outputCount; ++i) {
            this.result.add(class_1799.method_7915((class_2487)nbt.method_10562("Output" + i)));
        }
        class_2499 list = nbt.method_10554("Incoming", 10);
        this.incoming = NBTHelper.readCompoundList((class_2499)list, TransportedItemStack::read);
    }

    public void write(class_2487 nbt, boolean clientPacket) {
        if (this.offer != null) {
            nbt.method_10566("Input", (class_2520)this.offer.serializeNBT());
        }
        nbt.method_10569("OutputCount", this.result.size());
        for (int i = 0; i < this.result.size(); ++i) {
            nbt.method_10566("Output" + i, (class_2520)this.result.get(i).method_7953(new class_2487()));
        }
        if (!this.incoming.isEmpty()) {
            nbt.method_10566("Incoming", (class_2520)NBTHelper.writeCompoundList(this.incoming, TransportedItemStack::serializeNBT));
        }
    }

    public LazyOptional<TradingDepotItemHandler> getItemHandler() {
        return this.itemHandlerLazyOptional;
    }

    public class_1799 getOfferStack() {
        return this.offer == null ? class_1799.field_8037 : this.offer.stack;
    }

    public void setOfferStack(TransportedItemStack input) {
        this.offer = input;
    }

    @Override
    public void setOfferStack(class_1799 input) {
        if (this.offer != null) {
            this.offer.stack = input;
        } else {
            this.offer = new TransportedItemStack(input);
        }
    }

    public void removeOfferStack() {
        this.offer = null;
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void combineOutputs() {
        ArrayList<class_1799> result = new ArrayList<class_1799>();
        for (class_1799 stack : this.result) {
            for (class_1799 other : result) {
                if (!ItemHandlerHelper.canItemStacksStack((class_1799)stack, (class_1799)other)) continue;
                int newCount = Math.min(other.method_7947() + stack.method_7947(), other.method_7914());
                int filledCount = newCount - other.method_7947();
                other.method_7939(newCount);
                stack.method_7939(stack.method_7947() - filledCount);
            }
            if (stack.method_7960()) continue;
            result.add(stack);
        }
        this.result = result;
    }

    public boolean canBeUsedFor(class_1914 offer) {
        return this.filtering.test(offer.method_8250());
    }

    public void addContentsToTooltip(List<class_2561> tooltip) {
        TFLang.translate("tooltip.trading_depot.contents", new Object[0]).forGoggles(tooltip);
        if (this.offer != null && !this.offer.stack.method_7960()) {
            TFLang.translate("tooltip.trading_depot.contents.input", new Object[0]).style(class_124.field_1080).forGoggles(tooltip, 1);
            TFLang.itemStack(this.offer.stack).style(class_124.field_1080).forGoggles(tooltip, 2);
        }
        if (!this.result.isEmpty()) {
            TFLang.translate("tooltip.trading_depot.contents.output", new Object[0]).style(class_124.field_1080).forGoggles(tooltip, 1);
            for (class_1799 stack : this.result) {
                TFLang.itemStack(stack).style(class_124.field_1080).forGoggles(tooltip, 2);
            }
        }
    }

    @Override
    public List<class_1799> getResults() {
        return this.result;
    }

    public void invalidate() {
        this.itemHandlerLazyOptional.invalidate();
    }

    public void resetInv() {
        this.invVersionTracker.reset();
    }

    @Override
    public TransportedItemStack getOffer() {
        return this.offer;
    }

    @Override
    public List<TransportedItemStack> getIncoming() {
        return this.incoming;
    }

    public TradingDepotItemHandler getRealItemHandler() {
        return this.itemHandler;
    }

    public void queueResultStackPrune() {
        this.pruneResultStackNextTick = true;
    }

    public void spinOfferOrSomething() {
        this.offer.angle = this.offer.angle + (int)((Math.random() * 10.0 + 10.0) * (double)(Math.random() > 0.5 ? -1 : 1));
    }
}

