/*
 * Decompiled with CFR 0.152.
 */
package com.cak.trading_floor.foundation;

import com.cak.trading_floor.foundation.TFPlatformPackets;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class ParticleEmitter {
    final class_2400 particleType;
    class_238 volume = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    class_243 randomVelocityStrength = class_243.field_1353;
    class_243 emitFromCenterStrength = class_243.field_1353;
    int sendPacketRange = 16;

    public ParticleEmitter(class_2400 particleType) {
        this.particleType = particleType;
    }

    public void emitToClients(class_3218 level, class_243 origin, int count) {
        TFPlatformPackets.sendEmitParticlesToNear(level, this, origin, count, class_2338.method_49638((class_2374)origin), this.sendPacketRange);
    }

    public void emitParticles(class_638 level, class_243 origin, int count) {
        this.emitWithConsumer((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((class_638)level).method_8406(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), origin, count);
    }

    public void emitWithConsumer(ParticleDataConsumer consumer, class_243 origin, int count) {
        boolean hasAABB = !this.volume.equals((Object)new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        boolean doEmitFromCenter = !this.emitFromCenterStrength.equals((Object)class_243.field_1353);
        boolean hasVelocity = !this.randomVelocityStrength.equals((Object)class_243.field_1353);
        for (int i = 0; i < count; ++i) {
            class_243 position = this.generateRandomPosition(hasAABB, origin);
            class_243 velocity = hasVelocity ? this.generateRandomVelocityOfPosition(doEmitFromCenter, origin, position) : class_243.field_1353;
            consumer.addParticle(this.particleType, position.field_1352, position.field_1351, position.field_1350, velocity.field_1352, velocity.field_1351, velocity.field_1350);
        }
    }

    protected class_243 generateRandomVelocityOfPosition(boolean doEmitFromCenter, class_243 origin, class_243 position) {
        class_243 baseVelocity = new class_243(this.randomVelocityStrength.field_1352 * Math.random(), this.randomVelocityStrength.field_1351 * Math.random(), this.randomVelocityStrength.field_1350 * Math.random());
        if (!doEmitFromCenter) {
            return baseVelocity;
        }
        class_243 offset = position.method_1020(origin).method_1029();
        if (offset.equals((Object)class_243.field_1353)) {
            return baseVelocity;
        }
        baseVelocity = baseVelocity.method_1031(this.emitFromCenterStrength.field_1352 * offset.field_1352, this.emitFromCenterStrength.field_1351 * offset.field_1351, this.emitFromCenterStrength.field_1350 * offset.field_1350);
        return baseVelocity;
    }

    protected class_243 generateRandomPosition(boolean hasAABB, class_243 origin) {
        if (!hasAABB) {
            return origin;
        }
        class_243 offset = new class_243(this.volume.field_1323 + this.volume.method_17939() * Math.random(), this.volume.field_1322 + this.volume.method_17940() * Math.random(), this.volume.field_1321 + this.volume.method_17941() * Math.random());
        return origin.method_1019(offset);
    }

    public ParticleEmitter setVolume(@NotNull class_238 volume) {
        this.volume = volume;
        return this;
    }

    public ParticleEmitter setRandomVelocityStrength(@NotNull class_243 randomVelocityStrength) {
        this.randomVelocityStrength = randomVelocityStrength;
        return this;
    }

    public ParticleEmitter setRandomVelocityStrength(float randomVelocityStrength) {
        return this.setRandomVelocityStrength(new class_243((double)randomVelocityStrength, (double)randomVelocityStrength, (double)randomVelocityStrength));
    }

    public ParticleEmitter setEmitFromCenterStrength(@NotNull class_243 emitFromCenterStrength) {
        this.emitFromCenterStrength = emitFromCenterStrength;
        return this;
    }

    public ParticleEmitter setEmitFromCenterStrength(float emitFromCenterStrength) {
        return this.setRandomVelocityStrength(new class_243((double)emitFromCenterStrength, (double)emitFromCenterStrength, (double)emitFromCenterStrength));
    }

    public ParticleEmitter setSendPacketRange(int sendPacketRange) {
        this.sendPacketRange = sendPacketRange;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParticleEmitter)) {
            return false;
        }
        ParticleEmitter that = (ParticleEmitter)o;
        return Objects.equals(this.emitFromCenterStrength, that.emitFromCenterStrength) && this.sendPacketRange == that.sendPacketRange && Objects.equals(this.particleType, that.particleType) && Objects.equals(this.volume, that.volume) && Objects.equals(this.randomVelocityStrength, that.randomVelocityStrength);
    }

    public int hashCode() {
        return Objects.hash(class_7923.field_41180.method_10221((Object)this.particleType), this.volume, this.randomVelocityStrength, this.emitFromCenterStrength, this.sendPacketRange);
    }

    public static interface ParticleDataConsumer {
        public void addParticle(class_2400 var1, double var2, double var4, double var6, double var8, double var10, double var12);
    }
}

