/*
 * Decompiled with CFR 0.152.
 */
package com.cak.trading_floor.foundation.advancement;

import com.cak.trading_floor.foundation.TFPlatformPredicates;
import com.cak.trading_floor.foundation.advancement.TFAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3222;

public class TFAdvancementBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<TFAdvancementBehaviour> TYPE = new BehaviourType();
    private UUID playerId;
    private final Set<TFAdvancement> advancements = new HashSet<TFAdvancement>();

    public static void create(List<BlockEntityBehaviour> behaviours, SmartBlockEntity be, TFAdvancement ... advancements) {
        TFAdvancementBehaviour existing = behaviours.stream().filter(blockEntityBehaviour -> blockEntityBehaviour instanceof TFAdvancementBehaviour).findFirst().orElse(null);
        if (existing != null) {
            existing.advancements.addAll(List.of(advancements));
        } else {
            behaviours.add(new TFAdvancementBehaviour(be, advancements));
        }
    }

    protected TFAdvancementBehaviour(SmartBlockEntity be, TFAdvancement ... advancements) {
        super(be);
        this.add(advancements);
    }

    public void add(TFAdvancement ... advancements) {
        this.advancements.addAll(Arrays.asList(advancements));
    }

    public boolean isOwnerPresent() {
        return this.playerId != null;
    }

    public void setPlayer(UUID id) {
        class_1657 player = this.getWorld().method_18470(id);
        if (player == null) {
            return;
        }
        this.playerId = id;
        this.removeAwarded();
        this.blockEntity.method_5431();
    }

    public void initialize() {
        super.initialize();
        this.removeAwarded();
    }

    private void removeAwarded() {
        class_1657 player = this.getPlayer();
        if (player == null) {
            return;
        }
        this.advancements.removeIf(c -> c.isAlreadyAwardedTo(player));
        if (this.advancements.isEmpty()) {
            this.playerId = null;
            this.blockEntity.method_5431();
        }
    }

    public void awardPlayerIfNear(TFAdvancement advancement, int maxDistance) {
        class_1657 player = this.getPlayer();
        if (player == null) {
            return;
        }
        if (player.method_5707(class_243.method_24953((class_2382)this.getPos())) > (double)(maxDistance * maxDistance)) {
            return;
        }
        this.award(advancement, player);
    }

    public void awardPlayer(TFAdvancement advancement) {
        class_1657 player = this.getPlayer();
        if (player == null) {
            return;
        }
        this.award(advancement, player);
    }

    private void award(TFAdvancement advancement, class_1657 player) {
        if (this.advancements.contains(advancement)) {
            advancement.awardTo(player);
        }
        this.removeAwarded();
    }

    private class_1657 getPlayer() {
        if (this.playerId == null) {
            return null;
        }
        return this.getWorld().method_18470(this.playerId);
    }

    public void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        if (this.playerId != null) {
            nbt.method_25927("Owner", this.playerId);
        }
    }

    public void read(class_2487 nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (nbt.method_10545("Owner")) {
            this.playerId = nbt.method_25926("Owner");
        }
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public static void tryAward(class_1922 reader, class_2338 pos, TFAdvancement advancement) {
        TFAdvancementBehaviour behaviour = (TFAdvancementBehaviour)BlockEntityBehaviour.get((class_1922)reader, (class_2338)pos, TYPE);
        if (behaviour != null) {
            behaviour.awardPlayer(advancement);
        }
    }

    public static void setPlacedBy(class_1937 worldIn, class_2338 pos, class_1309 placer) {
        TFAdvancementBehaviour behaviour = (TFAdvancementBehaviour)BlockEntityBehaviour.get((class_1922)worldIn, (class_2338)pos, TYPE);
        if (behaviour == null) {
            return;
        }
        if (TFPlatformPredicates.isFakePlayer(placer)) {
            return;
        }
        if (placer instanceof class_3222) {
            behaviour.setPlayer(placer.method_5667());
        }
    }
}

