/*
 * Decompiled with CFR 0.152.
 */
package com.cak.trading_floor.foundation.ponder_scenes;

import com.cak.trading_floor.content.trading_depot.CommonTradingDepotBlockEntity;
import com.cak.trading_floor.registry.TFParticleEmitters;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import net.minecraft.class_1299;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3852;

public class TradingDepotScenes {
    public static void trading(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("trading_depot_trading", "Trading with trading depots");
        scene.configureBasePlate(0, 0, 3);
        scene.showBasePlate();
        scene.idle(10);
        scene.world.showSection(util.select.position(1, 1, 1), class_2350.field_11033);
        scene.idle(10);
        scene.overlay.showText(80).placeNearTarget().pointAt(new class_243(1.5, 1.5, 1.5)).text("To use a trading depot, attach it to a villager workstation");
        scene.addKeyframe();
        scene.idle(80);
        scene.world.showSection(util.select.position(1, 1, 2), class_2350.field_11033);
        scene.idle(40);
        scene.overlay.showOutline(PonderPalette.GREEN, (Object)"Depot Highlight", util.select.position(1, 1, 1), 30);
        scene.idle(1);
        scene.overlay.showOutline(PonderPalette.WHITE, (Object)"Workstation Highlight", util.select.position(1, 1, 2), 28);
        scene.addKeyframe();
        scene.idle(80);
        scene.world.modifyBlockEntity(new class_2338(1, 1, 1), CommonTradingDepotBlockEntity.class, be -> {
            TransportedItemStack tis = new TransportedItemStack(class_1802.field_8145.method_7854().method_46651(32));
            tis.insertedFrom = class_2350.field_11035;
            be.getCommonTradingDepotBehaviour().getIncoming().add(tis);
        });
        scene.idle(20);
        ElementLink villager = scene.world.createEntity(level -> {
            class_1646 newEntity = new class_1646(class_1299.field_6077, level);
            newEntity.method_5814(2.5, 1.0, 2.5);
            newEntity.method_5847(90.0f);
            newEntity.method_5636(90.0f);
            newEntity.method_22862();
            newEntity.method_5773();
            newEntity.method_7195(newEntity.method_7231().method_16921(class_3852.field_17058));
            return newEntity;
        });
        scene.idle(40);
        scene.overlay.showText(80).placeNearTarget().pointAt(new class_243(1.5, 1.5, 1.5)).text("When a villager next works at their workstation they will trade with the attached depot");
        scene.addKeyframe();
        scene.idle(40);
        scene.world.modifyEntity(villager, entity -> {
            class_1646 villagerEntity = (class_1646)entity;
            villagerEntity.method_36457(10.0f);
        });
        scene.idle(1);
        scene.world.modifyEntity(villager, entity -> {
            class_1646 villagerEntity = (class_1646)entity;
            villagerEntity.method_36457(20.0f);
        });
        scene.idle(20);
        scene.addInstruction(activeScene -> TFParticleEmitters.TRADE_COMPLETED.emitWithConsumer((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((PonderWorld)activeScene.getWorld()).method_8406(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), new class_243(1.5, 1.9, 1.5), 4));
        scene.world.modifyBlockEntity(new class_2338(1, 1, 1), CommonTradingDepotBlockEntity.class, be -> {
            be.getCommonTradingDepotBehaviour().setOfferStack(class_1799.field_8037);
            be.getCommonTradingDepotBehaviour().getResults().add(class_1802.field_8687.method_7854());
        });
        scene.markAsFinished();
    }

    public static void trading_double(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("trading_depot_double_trading", "Trading with multiple trading depots");
        scene.configureBasePlate(0, 0, 6);
        scene.showBasePlate();
        scene.idle(20);
        scene.world.showSection(util.select.fromTo(6, 0, 0, 6, 2, 5), class_2350.field_11039);
        scene.idle(20);
        scene.world.showSection(util.select.layer(1).substract(util.select.fromTo(6, 0, 0, 6, 2, 5)).substract(util.select.position(0, 1, 3)), class_2350.field_11033);
        scene.idle(20);
        scene.world.showSection(util.select.layer(2).substract(util.select.fromTo(6, 0, 0, 6, 2, 5)).substract(util.select.position(2, 2, 2)).substract(util.select.position(1, 2, 3)), class_2350.field_11033);
        scene.world.showSection(util.select.position(0, 1, 3).add(util.select.position(1, 2, 3)), class_2350.field_11033);
        scene.addKeyframe();
        scene.idle(20);
        scene.overlay.showText(80).placeNearTarget().pointAt(new class_243(3.5, 2.5, 3.5)).text("To complete trades with multiple inputs, 2 depots can be used together");
        scene.idle(90);
        scene.overlay.showText(80).placeNearTarget().pointAt(new class_243(3.5, 2.5, 2.5)).text("While not required, you should set the filter on the first input to avoid other trades");
        scene.idle(90);
        scene.world.createItemOnBelt(new class_2338(3, 2, 0), class_2350.field_11043, class_1802.field_8687.method_7854());
        scene.world.createItemOnBelt(new class_2338(0, 1, 3), class_2350.field_11039, class_1802.field_8110.method_7854().method_46651(10));
        scene.idle(60);
        ElementLink villager = scene.world.createEntity(level -> {
            class_1646 newEntity = new class_1646(class_1299.field_6077, level);
            newEntity.method_5814(4.5, 2.0, 4.5);
            newEntity.method_5847(135.0f);
            newEntity.method_5636(135.0f);
            newEntity.method_22862();
            newEntity.method_5773();
            newEntity.method_7195(newEntity.method_7231().method_16921(class_3852.field_17058));
            return newEntity;
        });
        scene.addKeyframe();
        scene.idle(20);
        scene.overlay.showText(80).placeNearTarget().pointAt(new class_243(3.5, 2.5, 2.5)).text("Note that trading depots will only share contents if they have matching filters, or the other is empty");
        scene.idle(90);
        scene.world.modifyEntity(villager, entity -> {
            class_1646 villagerEntity = (class_1646)entity;
            villagerEntity.method_36457(10.0f);
        });
        scene.idle(1);
        scene.world.modifyEntity(villager, entity -> {
            class_1646 villagerEntity = (class_1646)entity;
            villagerEntity.method_36457(20.0f);
        });
        scene.addKeyframe();
        scene.idle(20);
        scene.addInstruction(activeScene -> TFParticleEmitters.TRADE_COMPLETED.emitWithConsumer((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((PonderWorld)activeScene.getWorld()).method_8406(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), new class_243(3.5, 2.9, 2.5), 4));
        scene.world.modifyBlockEntity(new class_2338(3, 2, 2), CommonTradingDepotBlockEntity.class, tradingDepotBlockEntity -> tradingDepotBlockEntity.getCommonTradingDepotBehaviour().setOfferStack(class_1799.field_8037));
        scene.world.modifyBlockEntity(new class_2338(2, 2, 3), CommonTradingDepotBlockEntity.class, tradingDepotBlockEntity -> tradingDepotBlockEntity.getCommonTradingDepotBehaviour().setOfferStack(class_1799.field_8037));
        scene.world.modifyBlockEntity(new class_2338(3, 2, 2), CommonTradingDepotBlockEntity.class, tradingDepotBlockEntity -> tradingDepotBlockEntity.getCommonTradingDepotBehaviour().getResults().add(class_1802.field_8145.method_7854().method_46651(10)));
        scene.idle(20);
        scene.overlay.showText(80).placeNearTarget().pointAt(new class_243(3.5, 2.5, 2.5)).text("The output then goes to whichever depot has the first item of the trade");
        scene.idle(90);
        scene.world.showSection(util.select.position(2, 2, 2), class_2350.field_11033);
        scene.idle(20);
        scene.world.modifyBlockEntity(new class_2338(3, 2, 2), CommonTradingDepotBlockEntity.class, tradingDepotBlockEntity -> tradingDepotBlockEntity.getCommonTradingDepotBehaviour().getResults().clear());
        scene.world.createItemOnBelt(new class_2338(2, 1, 2), class_2350.field_11034, class_1802.field_8145.method_7854().method_46651(10));
        scene.idle(20);
        scene.markAsFinished();
    }
}

