/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.config.schema.builder;

import com.mojang.serialization.Codec;
import java.util.function.IntFunction;
import net.blay09.mods.balm.api.config.LenientEnumCodecs;
import net.blay09.mods.balm.api.config.schema.ConfiguredEnum;
import net.blay09.mods.balm.api.config.schema.builder.AbstractConfigProperty;
import net.blay09.mods.balm.api.config.schema.builder.ConfigPropertyBuilder;
import net.blay09.mods.balm.common.codec.ByteBufCodecs;
import net.blay09.mods.balm.common.codec.StreamCodec;
import net.minecraft.class_2540;
import net.minecraft.class_7995;

public class EnumConfigProperty<T extends Enum<T>>
extends AbstractConfigProperty<T>
implements ConfiguredEnum<T> {
    private final T defaultValue;
    private final Codec<T> codec;
    private final StreamCodec<class_2540, T> streamCodec;

    public EnumConfigProperty(ConfigPropertyBuilder parent, T defaultValue) {
        super(parent);
        this.defaultValue = defaultValue;
        Class enumClass = ((Enum)defaultValue).getDeclaringClass();
        IntFunction byIdMapper = class_7995.method_47914(Enum::ordinal, (Object[])((Enum[])enumClass.getEnumConstants()), (class_7995.class_7996)class_7995.class_7996.field_41664);
        this.codec = LenientEnumCodecs.fromValues(enumClass::getEnumConstants);
        this.streamCodec = ByteBufCodecs.idMapper(byIdMapper, Enum::ordinal);
    }

    @Override
    public Class<T> type() {
        return ((Enum)this.defaultValue).getDeclaringClass();
    }

    @Override
    public Codec<T> codec() {
        return this.codec;
    }

    @Override
    public StreamCodec<class_2540, T> streamCodec() {
        return this.streamCodec;
    }

    @Override
    public T defaultValue() {
        return this.defaultValue;
    }
}

